/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.preprocess;

import ai.djl.modality.cv.Image;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import cn.smartjavaai.common.cv.SmartImageFactory;
import cn.smartjavaai.common.entity.DetectionRectangle;
import cn.smartjavaai.common.utils.OpenCVUtils;
import cn.smartjavaai.face.utils.FaceAlignUtils;
import cn.smartjavaai.face.utils.FaceUtils;
import java.awt.image.BufferedImage;
import java.util.Objects;
import org.opencv.core.Mat;

public class DJLImageFacePreprocessor {
    private Image image;
    private NDManager manager;
    private boolean enableCrop = false;
    private DetectionRectangle cropRect;
    private boolean enableAffine = false;
    private double[][] keyPoints;
    private int affineTargetWidth;
    private int affineTargetHeight;

    public DJLImageFacePreprocessor(Image image, NDManager manager) {
        this.image = image;
        this.manager = manager;
    }

    public DJLImageFacePreprocessor enableCrop(DetectionRectangle rect) {
        this.enableCrop = true;
        this.cropRect = rect;
        return this;
    }

    public DJLImageFacePreprocessor enableAffine(double[][] keyPoints, int targetWidth, int targetHeight) {
        if (Objects.isNull(keyPoints)) {
            throw new IllegalArgumentException("keyPoints must be not null");
        }
        this.enableAffine = true;
        this.affineTargetWidth = targetWidth;
        this.affineTargetHeight = targetHeight;
        this.keyPoints = keyPoints;
        return this;
    }

    public Image process() {
        Image result = this.image;
        if (this.enableAffine) {
            result = this.warpAffine(this.keyPoints, this.affineTargetWidth, this.affineTargetHeight);
        } else if (this.enableCrop) {
            result = result.getSubImage(this.cropRect.x, this.cropRect.y, this.cropRect.width, this.cropRect.height);
        }
        return result;
    }

    private Image warpAffine(double[][] keyPoints, int width, int height) {
        NDArray srcPoints = this.manager.create(keyPoints);
        NDArray dstPoints = null;
        if (width == 512 && height == 512) {
            dstPoints = FaceUtils.faceTemplate512x512(this.manager);
        } else if (width == 112 && height == 112) {
            dstPoints = FaceUtils.faceTemplate112x112(this.manager);
        } else if (width == 96 && height == 112) {
            dstPoints = FaceUtils.faceTemplate96x112(this.manager);
        }
        Mat affine_matrix = OpenCVUtils.toOpenCVMat((NDManager)this.manager, (NDArray)srcPoints, (NDArray)dstPoints);
        Object imageObj = this.image.getWrappedImage();
        Mat src = this.image.getWrappedImage() instanceof Mat ? (Mat)imageObj : OpenCVUtils.image2Mat((BufferedImage)((BufferedImage)imageObj));
        Mat mat = FaceAlignUtils.warpAffine(src, affine_matrix, width, height);
        Image alignedImg = SmartImageFactory.getInstance().fromMat(mat);
        affine_matrix.release();
        return alignedImg;
    }
}

