/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.model.quality;

import ai.djl.modality.cv.Image;
import cn.smartjavaai.common.cv.SmartImageFactory;
import cn.smartjavaai.common.entity.DetectionRectangle;
import cn.smartjavaai.common.entity.Point;
import cn.smartjavaai.common.entity.R;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.common.utils.FileUtils;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.common.utils.PoolUtils;
import cn.smartjavaai.face.config.QualityConfig;
import cn.smartjavaai.face.entity.FaceQualityResult;
import cn.smartjavaai.face.entity.FaceQualitySummary;
import cn.smartjavaai.face.enums.QualityGrade;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.factory.FaceQualityModelFactory;
import cn.smartjavaai.face.model.quality.FaceQualityModel;
import cn.smartjavaai.face.seetaface.ClarityDLResult;
import cn.smartjavaai.face.seetaface.NativeLoader;
import cn.smartjavaai.face.utils.Seetaface6Utils;
import com.seeta.pool.QualityOfBrightnessPool;
import com.seeta.pool.QualityOfClarityPool;
import com.seeta.pool.QualityOfIntegrityPool;
import com.seeta.pool.QualityOfLBNPool;
import com.seeta.pool.QualityOfPoseExPool;
import com.seeta.pool.QualityOfPosePool;
import com.seeta.pool.QualityOfResolutionPool;
import com.seeta.pool.SeetaConfSetting;
import com.seeta.sdk.QualityOfBrightness;
import com.seeta.sdk.QualityOfClarity;
import com.seeta.sdk.QualityOfIntegrity;
import com.seeta.sdk.QualityOfLBN;
import com.seeta.sdk.QualityOfPose;
import com.seeta.sdk.QualityOfPoseEx;
import com.seeta.sdk.QualityOfResolution;
import com.seeta.sdk.SeetaDevice;
import com.seeta.sdk.SeetaImageData;
import com.seeta.sdk.SeetaModelSetting;
import com.seeta.sdk.SeetaPointF;
import com.seeta.sdk.SeetaRect;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.ObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Seetaface6QualityModel
implements FaceQualityModel {
    private static final Logger log = LoggerFactory.getLogger(Seetaface6QualityModel.class);
    private QualityConfig config;
    private QualityOfBrightnessPool qualityOfBrightnessPool;
    private QualityOfClarityPool qualityOfClarityPool;
    private QualityOfLBNPool qualityOfLBNPool;
    private QualityOfIntegrityPool qualityOfIntegrityPool;
    private QualityOfPosePool qualityOfPosePool;
    private QualityOfPoseExPool qualityOfPoseExPool;
    private QualityOfResolutionPool qualityOfResolutionPool;
    int predictorPoolSize = 0;
    private boolean fromFactory = false;

    @Override
    public void loadModel(QualityConfig config) {
        DeviceEnum device = DeviceEnum.CPU;
        if (Objects.nonNull(config.getDevice())) {
            device = config.getDevice();
        }
        NativeLoader.loadNativeLibraries(device);
        this.config = config;
        this.predictorPoolSize = config.getPredictorPoolSize();
        if (config.getPredictorPoolSize() <= 0) {
            this.predictorPoolSize = Runtime.getRuntime().availableProcessors();
        }
        log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + this.predictorPoolSize);
        log.debug("Loading seetaFace6 library successfully.");
    }

    @Override
    public R<FaceQualityResult> evaluateBrightness(BufferedImage image, DetectionRectangle rectangle, List<Point> keyPoints) {
        Image imageDjl = SmartImageFactory.getInstance().fromBufferedImage(image);
        R<FaceQualityResult> detectionResponseR = this.evaluateBrightness(imageDjl, rectangle, keyPoints);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    @Override
    public R<FaceQualityResult> evaluateBrightness(String imagePath, DetectionRectangle rectangle, List<Point> keyPoints) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        Image image = null;
        try {
            R<FaceQualityResult> detectionResponseR;
            image = SmartImageFactory.getInstance().fromFile(imagePath);
            R<FaceQualityResult> r = detectionResponseR = this.evaluateBrightness(image, rectangle, keyPoints);
            return r;
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        finally {
            ImageUtils.releaseOpenCVMat((Image)image);
        }
    }

    @Override
    public R<FaceQualityResult> evaluateBrightness(byte[] imageData, DetectionRectangle rectangle, List<Point> keyPoints) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image imageDjl = null;
        try {
            imageDjl = SmartImageFactory.getInstance().fromBytes(imageData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        R<FaceQualityResult> detectionResponseR = this.evaluateBrightness(imageDjl, rectangle, keyPoints);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    @Override
    public R<FaceQualityResult> evaluateClarity(BufferedImage image, DetectionRectangle rectangle, List<Point> keyPoints) {
        Image imageDjl = SmartImageFactory.getInstance().fromBufferedImage(image);
        R<FaceQualityResult> detectionResponseR = this.evaluateClarity(imageDjl, rectangle, keyPoints);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    @Override
    public R<FaceQualityResult> evaluateClarity(String imagePath, DetectionRectangle rectangle, List<Point> keyPoints) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        Image image = null;
        try {
            R<FaceQualityResult> detectionResponseR;
            image = SmartImageFactory.getInstance().fromFile(imagePath);
            R<FaceQualityResult> r = detectionResponseR = this.evaluateClarity(image, rectangle, keyPoints);
            return r;
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        finally {
            ImageUtils.releaseOpenCVMat((Image)image);
        }
    }

    @Override
    public R<FaceQualityResult> evaluateClarity(byte[] imageData, DetectionRectangle rectangle, List<Point> keyPoints) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image imageDjl = null;
        try {
            imageDjl = SmartImageFactory.getInstance().fromBytes(imageData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        R<FaceQualityResult> detectionResponseR = this.evaluateClarity(imageDjl, rectangle, keyPoints);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    @Override
    public R<FaceQualityResult> evaluateCompleteness(BufferedImage image, DetectionRectangle rectangle, List<Point> keyPoints) {
        Image imageDjl = SmartImageFactory.getInstance().fromBufferedImage(image);
        R<FaceQualityResult> detectionResponseR = this.evaluateCompleteness(imageDjl, rectangle, keyPoints);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    @Override
    public R<FaceQualityResult> evaluateCompleteness(String imagePath, DetectionRectangle rectangle, List<Point> keyPoints) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        Image image = null;
        try {
            R<FaceQualityResult> detectionResponseR;
            image = SmartImageFactory.getInstance().fromFile(imagePath);
            R<FaceQualityResult> r = detectionResponseR = this.evaluateCompleteness(image, rectangle, keyPoints);
            return r;
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        finally {
            ImageUtils.releaseOpenCVMat((Image)image);
        }
    }

    @Override
    public R<FaceQualityResult> evaluateCompleteness(byte[] imageData, DetectionRectangle rectangle, List<Point> keyPoints) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image imageDjl = null;
        try {
            imageDjl = SmartImageFactory.getInstance().fromBytes(imageData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        R<FaceQualityResult> detectionResponseR = this.evaluateCompleteness(imageDjl, rectangle, keyPoints);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    @Override
    public R<FaceQualityResult> evaluatePose(BufferedImage image, DetectionRectangle rectangle, List<Point> keyPoints) {
        Image imageDjl = SmartImageFactory.getInstance().fromBufferedImage(image);
        R<FaceQualityResult> detectionResponseR = this.evaluatePose(imageDjl, rectangle, keyPoints);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    @Override
    public R<FaceQualityResult> evaluatePose(String imagePath, DetectionRectangle rectangle, List<Point> keyPoints) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        Image image = null;
        try {
            R<FaceQualityResult> detectionResponseR;
            image = SmartImageFactory.getInstance().fromFile(imagePath);
            R<FaceQualityResult> r = detectionResponseR = this.evaluatePose(image, rectangle, keyPoints);
            return r;
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        finally {
            ImageUtils.releaseOpenCVMat((Image)image);
        }
    }

    @Override
    public R<FaceQualityResult> evaluatePose(byte[] imageData, DetectionRectangle rectangle, List<Point> keyPoints) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image imageDjl = null;
        try {
            imageDjl = SmartImageFactory.getInstance().fromBytes(imageData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        R<FaceQualityResult> detectionResponseR = this.evaluatePose(imageDjl, rectangle, keyPoints);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    @Override
    public R<FaceQualityResult> evaluateResolution(BufferedImage image, DetectionRectangle rectangle, List<Point> keyPoints) {
        Image imageDjl = SmartImageFactory.getInstance().fromBufferedImage(image);
        R<FaceQualityResult> detectionResponseR = this.evaluateResolution(imageDjl, rectangle, keyPoints);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    @Override
    public R<FaceQualityResult> evaluateResolution(String imagePath, DetectionRectangle rectangle, List<Point> keyPoints) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        Image image = null;
        try {
            R<FaceQualityResult> detectionResponseR;
            image = SmartImageFactory.getInstance().fromFile(imagePath);
            R<FaceQualityResult> r = detectionResponseR = this.evaluateResolution(image, rectangle, keyPoints);
            return r;
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        finally {
            ImageUtils.releaseOpenCVMat((Image)image);
        }
    }

    @Override
    public R<FaceQualityResult> evaluateResolution(byte[] imageData, DetectionRectangle rectangle, List<Point> keyPoints) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image imageDjl = null;
        try {
            imageDjl = SmartImageFactory.getInstance().fromBytes(imageData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        R<FaceQualityResult> detectionResponseR = this.evaluateResolution(imageDjl, rectangle, keyPoints);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    public R<ClarityDLResult> evaluateClarityWithDL(Image image, List<Point> keyPoints) {
        if (Objects.isNull(image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        if (Objects.isNull(keyPoints) || keyPoints.isEmpty()) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"keyPoints\u4e3a\u7a7a");
        }
        QualityOfLBN qualityOfLBN = null;
        try {
            if (Objects.isNull(this.qualityOfLBNPool)) {
                if (Objects.isNull((Object)this.config)) {
                    R r = R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"\u7f3a\u5c11\u5fc5\u8981\u914d\u7f6e\uff08QualityConfig\uff09\uff0c\u8bf7\u5728\u8c03\u7528\u524d\u521d\u59cb\u5316\u6a21\u578b\u914d\u7f6e");
                    return r;
                }
                if (StringUtils.isBlank((CharSequence)this.config.getModelPath())) {
                    R r = R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"QualityConfig\u4e2d\uff0cmodelPath\u4e3a\u7a7a");
                    return r;
                }
                SeetaConfSetting setting = this.getClarityMLSetting();
                this.qualityOfLBNPool = new QualityOfLBNPool(setting);
                this.qualityOfLBNPool.setMaxTotal(this.predictorPoolSize);
            }
            qualityOfLBN = (QualityOfLBN)this.qualityOfLBNPool.borrowObject();
            SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
            imageData.data = ImageUtils.getMatrixBGR((Image)image);
            SeetaPointF[] pointFS = Seetaface6Utils.convertToSeetaPointF(keyPoints);
            int[] light = new int[1];
            int[] blur = new int[1];
            int[] noise = new int[1];
            qualityOfLBN.Detect(imageData, pointFS, light, blur, noise);
            R r = R.ok((Object)new ClarityDLResult(light, blur, noise));
            return r;
        }
        catch (Exception e) {
            throw new FaceException("\u4eae\u5ea6\u8bc4\u4f30\u9519\u8bef", e);
        }
        finally {
            if (qualityOfLBN != null) {
                try {
                    this.qualityOfLBNPool.returnObject((Object)qualityOfLBN);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    public R<FaceQualityResult> evaluatePoseWithDL(Image image, DetectionRectangle rectangle, List<Point> keyPoints) {
        if (Objects.isNull(image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        if (Objects.isNull(rectangle)) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"rectangle\u4e3a\u7a7a");
        }
        if (Objects.isNull(keyPoints) || keyPoints.isEmpty()) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"keyPoints\u4e3a\u7a7a");
        }
        QualityOfPoseEx qualityOfPoseEx = null;
        try {
            if (Objects.isNull(this.qualityOfPoseExPool)) {
                if (Objects.isNull((Object)this.config)) {
                    R r = R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"\u7f3a\u5c11\u5fc5\u8981\u914d\u7f6e\uff08QualityConfig\uff09\uff0c\u8bf7\u5728\u8c03\u7528\u524d\u521d\u59cb\u5316\u6a21\u578b\u914d\u7f6e");
                    return r;
                }
                if (StringUtils.isBlank((CharSequence)this.config.getModelPath())) {
                    R r = R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"QualityConfig\u4e2d\uff0cmodelPath\u4e3a\u7a7a");
                    return r;
                }
                SeetaConfSetting setting = this.getPoseMLSetting();
                this.qualityOfPoseExPool = new QualityOfPoseExPool(setting);
                this.qualityOfPoseExPool.setMaxTotal(this.predictorPoolSize);
            }
            qualityOfPoseEx = (QualityOfPoseEx)this.qualityOfPoseExPool.borrowObject();
            SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
            imageData.data = ImageUtils.getMatrixBGR((Image)image);
            SeetaPointF[] pointFS = Seetaface6Utils.convertToSeetaPointF(keyPoints);
            SeetaRect seetaRect = Seetaface6Utils.convertToSeetaRect(rectangle);
            float[] scores = new float[1];
            QualityOfPoseEx.QualityLevel level = qualityOfPoseEx.check(imageData, seetaRect, pointFS, scores);
            FaceQualityResult result = new FaceQualityResult(scores[0], QualityGrade.valueOf(level.name()));
            R r = R.ok((Object)result);
            return r;
        }
        catch (Exception e) {
            throw new FaceException("\u4eae\u5ea6\u8bc4\u4f30\u9519\u8bef", e);
        }
        finally {
            if (qualityOfPoseEx != null) {
                try {
                    this.qualityOfPoseExPool.returnObject((Object)qualityOfPoseEx);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    private SeetaConfSetting getClarityMLSetting() throws FileNotFoundException {
        String[] modelPath = new String[]{this.config.getModelPath() + File.separator + "quality_lbn.csta"};
        SeetaDevice device = SeetaDevice.SEETA_DEVICE_AUTO;
        int gpuId = 0;
        if (Objects.nonNull(this.config.getDevice())) {
            SeetaDevice seetaDevice = device = this.config.getDevice() == DeviceEnum.CPU ? SeetaDevice.SEETA_DEVICE_CPU : SeetaDevice.SEETA_DEVICE_GPU;
            if (this.config.getGpuId() >= 0 && device == SeetaDevice.SEETA_DEVICE_GPU) {
                gpuId = this.config.getGpuId();
            }
        }
        SeetaConfSetting setting = new SeetaConfSetting(new SeetaModelSetting(gpuId, modelPath, device));
        return setting;
    }

    private SeetaConfSetting getPoseMLSetting() throws FileNotFoundException {
        String[] modelPath = new String[]{this.config.getModelPath() + File.separator + "pose_estimation.csta"};
        SeetaDevice device = SeetaDevice.SEETA_DEVICE_AUTO;
        int gpuId = 0;
        if (Objects.nonNull(this.config.getDevice())) {
            SeetaDevice seetaDevice = device = this.config.getDevice() == DeviceEnum.CPU ? SeetaDevice.SEETA_DEVICE_CPU : SeetaDevice.SEETA_DEVICE_GPU;
            if (this.config.getGpuId() >= 0 && device == SeetaDevice.SEETA_DEVICE_GPU) {
                gpuId = this.config.getGpuId();
            }
        }
        SeetaConfSetting setting = new SeetaConfSetting(new SeetaModelSetting(gpuId, modelPath, device));
        return setting;
    }

    @Override
    public R<FaceQualitySummary> evaluateAll(String imagePath, DetectionRectangle rectangle, List<Point> keyPoints) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        Image image = null;
        try {
            R<FaceQualitySummary> detectionResponseR;
            image = SmartImageFactory.getInstance().fromFile(imagePath);
            R<FaceQualitySummary> r = detectionResponseR = this.evaluateAll(image, rectangle, keyPoints);
            return r;
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        finally {
            ImageUtils.releaseOpenCVMat((Image)image);
        }
    }

    @Override
    public R<FaceQualitySummary> evaluateAll(BufferedImage image, DetectionRectangle rectangle, List<Point> keyPoints) {
        Image imageDjl = SmartImageFactory.getInstance().fromBufferedImage(image);
        R<FaceQualitySummary> detectionResponseR = this.evaluateAll(imageDjl, rectangle, keyPoints);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    @Override
    public R<FaceQualitySummary> evaluateAll(byte[] imageData, DetectionRectangle rectangle, List<Point> keyPoints) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image imageDjl = null;
        try {
            imageDjl = SmartImageFactory.getInstance().fromBytes(imageData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        R<FaceQualitySummary> detectionResponseR = this.evaluateAll(imageDjl, rectangle, keyPoints);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    @Override
    public R<FaceQualityResult> evaluateBrightness(Image image, DetectionRectangle rectangle, List<Point> keyPoints) {
        if (Objects.isNull(image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        if (Objects.isNull(rectangle)) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"rectangle\u4e3a\u7a7a");
        }
        if (Objects.isNull(keyPoints) || keyPoints.isEmpty()) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"keyPoints\u4e3a\u7a7a");
        }
        QualityOfBrightness qualityOfBrightness = null;
        try {
            if (Objects.isNull(this.qualityOfBrightnessPool)) {
                this.qualityOfBrightnessPool = new QualityOfBrightnessPool(new SeetaConfSetting());
                this.qualityOfBrightnessPool.setMaxTotal(this.predictorPoolSize);
            }
            qualityOfBrightness = (QualityOfBrightness)this.qualityOfBrightnessPool.borrowObject();
            SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
            imageData.data = ImageUtils.getMatrixBGR((Image)image);
            SeetaRect seetaRect = Seetaface6Utils.convertToSeetaRect(rectangle);
            SeetaPointF[] pointFS = Seetaface6Utils.convertToSeetaPointF(keyPoints);
            float[] scores = new float[1];
            QualityOfBrightness.QualityLevel level = qualityOfBrightness.check(imageData, seetaRect, pointFS, scores);
            FaceQualityResult result = new FaceQualityResult(scores[0], QualityGrade.valueOf(level.name()));
            R r = R.ok((Object)result);
            return r;
        }
        catch (Exception e) {
            throw new FaceException("\u4eae\u5ea6\u8bc4\u4f30\u9519\u8bef", e);
        }
        finally {
            if (qualityOfBrightness != null) {
                try {
                    this.qualityOfBrightnessPool.returnObject((Object)qualityOfBrightness);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public R<FaceQualityResult> evaluateClarity(Image image, DetectionRectangle rectangle, List<Point> keyPoints) {
        if (Objects.isNull(image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        if (Objects.isNull(rectangle)) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"rectangle\u4e3a\u7a7a");
        }
        if (Objects.isNull(keyPoints) || keyPoints.isEmpty()) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"keyPoints\u4e3a\u7a7a");
        }
        QualityOfClarity qualityOfClarity = null;
        try {
            if (Objects.isNull(this.qualityOfClarityPool)) {
                this.qualityOfClarityPool = new QualityOfClarityPool(new SeetaConfSetting());
                this.qualityOfClarityPool.setMaxTotal(this.predictorPoolSize);
            }
            qualityOfClarity = (QualityOfClarity)this.qualityOfClarityPool.borrowObject();
            SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
            imageData.data = ImageUtils.getMatrixBGR((Image)image);
            SeetaRect seetaRect = Seetaface6Utils.convertToSeetaRect(rectangle);
            SeetaPointF[] pointFS = Seetaface6Utils.convertToSeetaPointF(keyPoints);
            float[] scores = new float[1];
            QualityOfClarity.QualityLevel level = qualityOfClarity.check(imageData, seetaRect, pointFS, scores);
            FaceQualityResult result = new FaceQualityResult(scores[0], QualityGrade.valueOf(level.name()));
            R r = R.ok((Object)result);
            return r;
        }
        catch (Exception e) {
            throw new FaceException("\u6e05\u6670\u5ea6\u8bc4\u4f30\u9519\u8bef", e);
        }
        finally {
            if (qualityOfClarity != null) {
                try {
                    this.qualityOfClarityPool.returnObject((Object)qualityOfClarity);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public R<FaceQualityResult> evaluateCompleteness(Image image, DetectionRectangle rectangle, List<Point> keyPoints) {
        if (Objects.isNull(image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        if (Objects.isNull(rectangle)) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"rectangle\u4e3a\u7a7a");
        }
        if (Objects.isNull(keyPoints) || keyPoints.isEmpty()) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"keyPoints\u4e3a\u7a7a");
        }
        QualityOfIntegrity qualityOfIntegrity = null;
        try {
            if (Objects.isNull(this.qualityOfIntegrityPool)) {
                this.qualityOfIntegrityPool = new QualityOfIntegrityPool(new SeetaConfSetting());
                this.qualityOfIntegrityPool.setMaxTotal(this.predictorPoolSize);
            }
            qualityOfIntegrity = (QualityOfIntegrity)this.qualityOfIntegrityPool.borrowObject();
            SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
            imageData.data = ImageUtils.getMatrixBGR((Image)image);
            SeetaRect seetaRect = Seetaface6Utils.convertToSeetaRect(rectangle);
            SeetaPointF[] pointFS = Seetaface6Utils.convertToSeetaPointF(keyPoints);
            float[] scores = new float[1];
            QualityOfIntegrity.QualityLevel level = qualityOfIntegrity.check(imageData, seetaRect, pointFS, scores);
            FaceQualityResult result = new FaceQualityResult(scores[0], QualityGrade.valueOf(level.name()));
            R r = R.ok((Object)result);
            return r;
        }
        catch (Exception e) {
            throw new FaceException("\u5b8c\u6574\u5ea6\u8bc4\u4f30\u9519\u8bef", e);
        }
        finally {
            if (qualityOfIntegrity != null) {
                try {
                    this.qualityOfIntegrityPool.returnObject((Object)qualityOfIntegrity);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public R<FaceQualityResult> evaluatePose(Image image, DetectionRectangle rectangle, List<Point> keyPoints) {
        if (Objects.isNull(image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        if (Objects.isNull(rectangle)) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"rectangle\u4e3a\u7a7a");
        }
        if (Objects.isNull(keyPoints) || keyPoints.isEmpty()) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"keyPoints\u4e3a\u7a7a");
        }
        QualityOfPose qualityOfPose = null;
        try {
            if (Objects.isNull(this.qualityOfPosePool)) {
                this.qualityOfPosePool = new QualityOfPosePool(new SeetaConfSetting());
                this.qualityOfPosePool.setMaxTotal(this.predictorPoolSize);
            }
            qualityOfPose = (QualityOfPose)this.qualityOfPosePool.borrowObject();
            SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
            imageData.data = ImageUtils.getMatrixBGR((Image)image);
            SeetaRect seetaRect = Seetaface6Utils.convertToSeetaRect(rectangle);
            SeetaPointF[] pointFS = Seetaface6Utils.convertToSeetaPointF(keyPoints);
            float[] scores = new float[1];
            QualityOfPose.QualityLevel level = qualityOfPose.check(imageData, seetaRect, pointFS, scores);
            FaceQualityResult result = new FaceQualityResult(scores[0], QualityGrade.valueOf(level.name()));
            R r = R.ok((Object)result);
            return r;
        }
        catch (Exception e) {
            throw new FaceException("\u59ff\u6001\u8bc4\u4f30\u9519\u8bef", e);
        }
        finally {
            if (qualityOfPose != null) {
                try {
                    this.qualityOfPosePool.returnObject((Object)qualityOfPose);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public R<FaceQualityResult> evaluateResolution(Image image, DetectionRectangle rectangle, List<Point> keyPoints) {
        if (Objects.isNull(image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        if (Objects.isNull(rectangle)) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"rectangle\u4e3a\u7a7a");
        }
        if (Objects.isNull(keyPoints) || keyPoints.isEmpty()) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"keyPoints\u4e3a\u7a7a");
        }
        QualityOfResolution qualityOfResolution = null;
        try {
            if (Objects.isNull(this.qualityOfResolutionPool)) {
                this.qualityOfResolutionPool = new QualityOfResolutionPool(new SeetaConfSetting());
                this.qualityOfResolutionPool.setMaxTotal(this.predictorPoolSize);
            }
            qualityOfResolution = (QualityOfResolution)this.qualityOfResolutionPool.borrowObject();
            SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
            imageData.data = ImageUtils.getMatrixBGR((Image)image);
            SeetaRect seetaRect = Seetaface6Utils.convertToSeetaRect(rectangle);
            SeetaPointF[] pointFS = Seetaface6Utils.convertToSeetaPointF(keyPoints);
            float[] scores = new float[1];
            QualityOfResolution.QualityLevel level = qualityOfResolution.check(imageData, seetaRect, pointFS, scores);
            FaceQualityResult result = new FaceQualityResult(scores[0], QualityGrade.valueOf(level.name()));
            R r = R.ok((Object)result);
            return r;
        }
        catch (Exception e) {
            throw new FaceException("\u59ff\u6001\u8bc4\u4f30\u9519\u8bef", e);
        }
        finally {
            if (qualityOfResolution != null) {
                try {
                    this.qualityOfResolutionPool.returnObject((Object)qualityOfResolution);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public R<FaceQualitySummary> evaluateAll(Image image, DetectionRectangle rectangle, List<Point> keyPoints) {
        R r;
        if (Objects.isNull(image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        if (Objects.isNull(rectangle)) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"rectangle\u4e3a\u7a7a");
        }
        if (Objects.isNull(keyPoints) || keyPoints.isEmpty()) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"keyPoints\u4e3a\u7a7a");
        }
        QualityOfBrightness qualityOfBrightness = null;
        QualityOfClarity qualityOfClarity = null;
        QualityOfIntegrity qualityOfIntegrity = null;
        QualityOfPose qualityOfPose = null;
        QualityOfResolution qualityOfResolution = null;
        try {
            if (Objects.isNull(this.qualityOfBrightnessPool)) {
                this.qualityOfBrightnessPool = new QualityOfBrightnessPool(new SeetaConfSetting());
                this.qualityOfBrightnessPool.setMaxTotal(this.predictorPoolSize);
            }
            if (Objects.isNull(this.qualityOfClarityPool)) {
                this.qualityOfClarityPool = new QualityOfClarityPool(new SeetaConfSetting());
                this.qualityOfClarityPool.setMaxTotal(this.predictorPoolSize);
            }
            if (Objects.isNull(this.qualityOfIntegrityPool)) {
                this.qualityOfIntegrityPool = new QualityOfIntegrityPool(new SeetaConfSetting());
                this.qualityOfIntegrityPool.setMaxTotal(this.predictorPoolSize);
            }
            if (Objects.isNull(this.qualityOfPosePool)) {
                this.qualityOfPosePool = new QualityOfPosePool(new SeetaConfSetting());
                this.qualityOfPosePool.setMaxTotal(this.predictorPoolSize);
            }
            if (Objects.isNull(this.qualityOfResolutionPool)) {
                this.qualityOfResolutionPool = new QualityOfResolutionPool(new SeetaConfSetting());
                this.qualityOfResolutionPool.setMaxTotal(this.predictorPoolSize);
            }
            FaceQualitySummary summary = new FaceQualitySummary();
            qualityOfBrightness = (QualityOfBrightness)this.qualityOfBrightnessPool.borrowObject();
            qualityOfClarity = (QualityOfClarity)this.qualityOfClarityPool.borrowObject();
            qualityOfIntegrity = (QualityOfIntegrity)this.qualityOfIntegrityPool.borrowObject();
            qualityOfPose = (QualityOfPose)this.qualityOfPosePool.borrowObject();
            qualityOfResolution = (QualityOfResolution)this.qualityOfResolutionPool.borrowObject();
            SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
            imageData.data = ImageUtils.getMatrixBGR((Image)image);
            SeetaRect seetaRect = Seetaface6Utils.convertToSeetaRect(rectangle);
            SeetaPointF[] pointFS = Seetaface6Utils.convertToSeetaPointF(keyPoints);
            float[] scoresBrightness = new float[1];
            QualityOfBrightness.QualityLevel level = qualityOfBrightness.check(imageData, seetaRect, pointFS, scoresBrightness);
            summary.setBrightness(new FaceQualityResult(scoresBrightness[0], QualityGrade.valueOf(level.name())));
            float[] scoresClarity = new float[1];
            QualityOfClarity.QualityLevel clarityLevel = qualityOfClarity.check(imageData, seetaRect, pointFS, scoresClarity);
            summary.setClarity(new FaceQualityResult(scoresClarity[0], QualityGrade.valueOf(clarityLevel.name())));
            float[] scoresIntegrity = new float[1];
            QualityOfIntegrity.QualityLevel integrityLevel = qualityOfIntegrity.check(imageData, seetaRect, pointFS, scoresIntegrity);
            summary.setCompleteness(new FaceQualityResult(scoresIntegrity[0], QualityGrade.valueOf(integrityLevel.name())));
            float[] scoresPose = new float[1];
            QualityOfPose.QualityLevel poseLevel = qualityOfPose.check(imageData, seetaRect, pointFS, scoresPose);
            summary.setPose(new FaceQualityResult(scoresPose[0], QualityGrade.valueOf(poseLevel.name())));
            float[] scoresResolution = new float[1];
            QualityOfResolution.QualityLevel resolutionLevel = qualityOfResolution.check(imageData, seetaRect, pointFS, scoresResolution);
            summary.setResolution(new FaceQualityResult(scoresResolution[0], QualityGrade.valueOf(resolutionLevel.name())));
            r = R.ok((Object)summary);
        }
        catch (Exception e) {
            try {
                throw new FaceException("\u4eae\u5ea6\u8bc4\u4f30\u9519\u8bef", e);
            }
            catch (Throwable throwable) {
                PoolUtils.returnToPool((ObjectPool)this.qualityOfBrightnessPool, qualityOfBrightness);
                PoolUtils.returnToPool((ObjectPool)this.qualityOfClarityPool, qualityOfClarity);
                PoolUtils.returnToPool((ObjectPool)this.qualityOfIntegrityPool, qualityOfIntegrity);
                PoolUtils.returnToPool((ObjectPool)this.qualityOfPosePool, qualityOfPose);
                PoolUtils.returnToPool((ObjectPool)this.qualityOfResolutionPool, qualityOfResolution);
                throw throwable;
            }
        }
        PoolUtils.returnToPool((ObjectPool)this.qualityOfBrightnessPool, (Object)qualityOfBrightness);
        PoolUtils.returnToPool((ObjectPool)this.qualityOfClarityPool, (Object)qualityOfClarity);
        PoolUtils.returnToPool((ObjectPool)this.qualityOfIntegrityPool, (Object)qualityOfIntegrity);
        PoolUtils.returnToPool((ObjectPool)this.qualityOfPosePool, (Object)qualityOfPose);
        PoolUtils.returnToPool((ObjectPool)this.qualityOfResolutionPool, (Object)qualityOfResolution);
        return r;
    }

    public QualityOfBrightnessPool getQualityOfBrightnessPool() {
        return this.qualityOfBrightnessPool;
    }

    public QualityOfClarityPool getQualityOfClarityPool() {
        return this.qualityOfClarityPool;
    }

    public QualityOfLBNPool getQualityOfLBNPool() {
        return this.qualityOfLBNPool;
    }

    public QualityOfIntegrityPool getQualityOfIntegrityPool() {
        return this.qualityOfIntegrityPool;
    }

    public QualityOfPosePool getQualityOfPosePool() {
        return this.qualityOfPosePool;
    }

    public QualityOfPoseExPool getQualityOfPoseExPool() {
        return this.qualityOfPoseExPool;
    }

    public QualityOfResolutionPool getQualityOfResolutionPool() {
        return this.qualityOfResolutionPool;
    }

    @Override
    public void close() throws Exception {
        if (this.fromFactory) {
            FaceQualityModelFactory.removeFromCache(this.config.getModelEnum());
        }
        if (Objects.nonNull(this.qualityOfBrightnessPool)) {
            this.qualityOfBrightnessPool.close();
        }
        if (Objects.nonNull(this.qualityOfClarityPool)) {
            this.qualityOfClarityPool.close();
        }
        if (Objects.nonNull(this.qualityOfLBNPool)) {
            this.qualityOfLBNPool.close();
        }
        if (Objects.nonNull(this.qualityOfIntegrityPool)) {
            this.qualityOfIntegrityPool.close();
        }
        if (Objects.nonNull(this.qualityOfPosePool)) {
            this.qualityOfPosePool.close();
        }
        if (Objects.nonNull(this.qualityOfPoseExPool)) {
            this.qualityOfPoseExPool.close();
        }
        if (Objects.nonNull(this.qualityOfResolutionPool)) {
            this.qualityOfResolutionPool.close();
        }
    }

    @Override
    public void setFromFactory(boolean fromFactory) {
        this.fromFactory = fromFactory;
    }

    public boolean isFromFactory() {
        return this.fromFactory;
    }
}

