/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.model.liveness.criterial;

import ai.djl.Device;
import ai.djl.modality.cv.Image;
import ai.djl.repository.zoo.Criteria;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.Translator;
import ai.djl.util.Progress;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.face.config.LivenessConfig;
import cn.smartjavaai.face.enums.LivenessModelEnum;
import cn.smartjavaai.face.model.liveness.translator.IicFrTranslator;
import java.nio.file.Paths;
import java.util.Objects;

public class LivenessCriteriaFactory {
    public static Criteria<Image, Float> createCriteria(LivenessConfig config) {
        Device device = null;
        if (!Objects.isNull(config.getDevice())) {
            device = config.getDevice() == DeviceEnum.CPU ? Device.cpu() : Device.gpu((int)config.getGpuId());
        }
        Criteria criteria = null;
        if (config.getModelEnum() == LivenessModelEnum.IIC_FL_MODEL) {
            criteria = Criteria.builder().optEngine("OnnxRuntime").setTypes(Image.class, Float.class).optModelPath(Paths.get(config.getModelPath(), new String[0])).optTranslator((Translator)new IicFrTranslator()).optProgress((Progress)new ProgressBar()).optDevice(device).build();
        }
        return criteria;
    }
}

