/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.model.liveness;

import ai.djl.modality.cv.Image;
import cn.smartjavaai.common.cv.SmartImageFactory;
import cn.smartjavaai.common.entity.DetectionInfo;
import cn.smartjavaai.common.entity.DetectionRectangle;
import cn.smartjavaai.common.entity.DetectionResponse;
import cn.smartjavaai.common.entity.Point;
import cn.smartjavaai.common.entity.R;
import cn.smartjavaai.common.entity.face.FaceInfo;
import cn.smartjavaai.common.entity.face.LivenessResult;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.common.enums.face.LivenessStatus;
import cn.smartjavaai.common.utils.FileUtils;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.face.config.LivenessConfig;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.factory.LivenessModelFactory;
import cn.smartjavaai.face.model.liveness.LivenessDetModel;
import cn.smartjavaai.face.seetaface.NativeLoader;
import cn.smartjavaai.face.utils.Seetaface6Utils;
import com.seeta.pool.FaceAntiSpoofingPool;
import com.seeta.pool.FaceDetectorPool;
import com.seeta.pool.FaceLandmarkerPool;
import com.seeta.pool.SeetaConfSetting;
import com.seeta.sdk.FaceAntiSpoofing;
import com.seeta.sdk.FaceDetector;
import com.seeta.sdk.FaceLandmarker;
import com.seeta.sdk.SeetaDevice;
import com.seeta.sdk.SeetaImageData;
import com.seeta.sdk.SeetaModelSetting;
import com.seeta.sdk.SeetaPointF;
import com.seeta.sdk.SeetaRect;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nu.pattern.OpenCV;
import org.apache.commons.lang3.StringUtils;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.Java2DFrameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Seetaface6LivenessModel
implements LivenessDetModel {
    private static final Logger log = LoggerFactory.getLogger(Seetaface6LivenessModel.class);
    private FaceDetectorPool faceDetectorPool;
    private FaceAntiSpoofingPool faceAntiSpoofingPool;
    private FaceLandmarkerPool faceLandmarkerPool;
    private LivenessConfig config;
    private boolean fromFactory = false;

    @Override
    public void loadModel(LivenessConfig config) {
        if (StringUtils.isBlank((CharSequence)config.getModelPath())) {
            throw new FaceException("modelPath is null");
        }
        this.config = config;
        NativeLoader.loadNativeLibraries(config.getDevice());
        log.debug("Loading seetaFace6 library successfully.");
        String[] faceDetectorModelPath = new String[]{config.getModelPath() + File.separator + "face_detector.csta"};
        String[] faceAntiSpoofingModelPath = new String[]{config.getModelPath() + File.separator + "fas_first.csta", config.getModelPath() + File.separator + "fas_second.csta"};
        String[] faceLandmarkerModelPath = new String[]{config.getModelPath() + File.separator + "face_landmarker_pts5.csta"};
        SeetaDevice device = SeetaDevice.SEETA_DEVICE_AUTO;
        int gpuId = config.getGpuId();
        if (Objects.nonNull(config.getDevice())) {
            device = config.getDevice() == DeviceEnum.CPU ? SeetaDevice.SEETA_DEVICE_CPU : SeetaDevice.SEETA_DEVICE_GPU;
        }
        try {
            SeetaModelSetting faceDetectorPoolSetting = new SeetaModelSetting(gpuId, faceDetectorModelPath, device);
            SeetaConfSetting faceDetectorPoolConfSetting = new SeetaConfSetting(faceDetectorPoolSetting);
            SeetaModelSetting faceLandmarkerPoolSetting = new SeetaModelSetting(gpuId, faceLandmarkerModelPath, device);
            SeetaConfSetting faceLandmarkerPoolConfSetting = new SeetaConfSetting(faceLandmarkerPoolSetting);
            SeetaModelSetting faceAntiSpoofingSetting = new SeetaModelSetting(gpuId, faceAntiSpoofingModelPath, device);
            SeetaConfSetting faceAntiSpoofingPoolConfSetting = new SeetaConfSetting(faceAntiSpoofingSetting);
            this.faceDetectorPool = new FaceDetectorPool(faceDetectorPoolConfSetting);
            this.faceAntiSpoofingPool = new FaceAntiSpoofingPool(faceAntiSpoofingPoolConfSetting);
            this.faceLandmarkerPool = new FaceLandmarkerPool(faceLandmarkerPoolConfSetting);
            int predictorPoolSize = config.getPredictorPoolSize();
            if (config.getPredictorPoolSize() <= 0) {
                predictorPoolSize = Runtime.getRuntime().availableProcessors();
            }
            this.faceDetectorPool.setMaxTotal(predictorPoolSize);
            this.faceAntiSpoofingPool.setMaxTotal(predictorPoolSize);
            this.faceLandmarkerPool.setMaxTotal(predictorPoolSize);
            log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + predictorPoolSize);
            this.initConfig();
        }
        catch (FileNotFoundException e) {
            throw new FaceException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initConfig() {
        FaceAntiSpoofing faceAntiSpoofing = null;
        try {
            Float realityThresholdValue;
            float faceClarityThreshold = 0.3f;
            float realityThreshold = 0.8f;
            Float faceClarityThresholdValue = (Float)this.config.getCustomParam("faceClarityThreshold", Float.class);
            if (Objects.nonNull(faceClarityThresholdValue)) {
                faceClarityThreshold = faceClarityThresholdValue.floatValue();
            }
            if (Objects.nonNull(realityThresholdValue = this.config.getRealityThreshold())) {
                realityThreshold = realityThresholdValue.floatValue();
            }
            faceAntiSpoofing = (FaceAntiSpoofing)this.faceAntiSpoofingPool.borrowObject();
            faceAntiSpoofing.SetThreshold(faceClarityThreshold, realityThreshold);
            faceAntiSpoofing.SetVideoFrameCount(this.config.getFrameCount());
            if (faceAntiSpoofing == null) return;
        }
        catch (Exception e) {
            try {
                throw new FaceException(e);
            }
            catch (Throwable throwable) {
                if (faceAntiSpoofing == null) throw throwable;
                try {
                    this.faceAntiSpoofingPool.returnObject(faceAntiSpoofing);
                    throw throwable;
                }
                catch (Exception e2) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            this.faceAntiSpoofingPool.returnObject((Object)faceAntiSpoofing);
            return;
        }
        catch (Exception e) {
            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            return;
        }
    }

    private R<LivenessResult> detect(Image image, DetectionRectangle faceDetectionRectangle, List<Point> keyPoints, boolean isImage) {
        if (Objects.isNull(faceDetectionRectangle)) {
            return R.fail((R.Status)R.Status.NO_FACE_DETECTED);
        }
        if (keyPoints == null || keyPoints.isEmpty()) {
            return R.fail((Integer)1002, (String)"\u4eba\u8138\u5173\u952e\u70b9keyPoints\u4e3a\u7a7a");
        }
        FaceAntiSpoofing.Status status = null;
        FaceAntiSpoofing faceAntiSpoofing = null;
        try {
            faceAntiSpoofing = (FaceAntiSpoofing)this.faceAntiSpoofingPool.borrowObject();
            SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
            imageData.data = ImageUtils.getMatrixBGR((Image)image);
            SeetaRect seetaRect = Seetaface6Utils.convertToSeetaRect(faceDetectionRectangle);
            SeetaPointF[] landmarks = Seetaface6Utils.convertToSeetaPointF(keyPoints);
            status = isImage ? faceAntiSpoofing.Predict(imageData, seetaRect, landmarks) : faceAntiSpoofing.PredictVideo(imageData, seetaRect, landmarks);
            R r = R.ok((Object)new LivenessResult(Seetaface6Utils.convertToLivenessStatus(status)));
            return r;
        }
        catch (Exception e) {
            throw new FaceException("\u6d3b\u4f53\u68c0\u6d4b\u9519\u8bef", e);
        }
        finally {
            if (faceAntiSpoofing != null) {
                try {
                    this.faceAntiSpoofingPool.returnObject((Object)faceAntiSpoofing);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    private R<LivenessResult> detectVideo(FFmpegFrameGrabber grabber) {
        FaceAntiSpoofing faceAntiSpoofing = null;
        try {
            faceAntiSpoofing = (FaceAntiSpoofing)this.faceAntiSpoofingPool.borrowObject();
            faceAntiSpoofing.ResetVideo();
            grabber.start();
            int totalFrames = grabber.getLengthInFrames();
            int videoFrameCountConfig = faceAntiSpoofing.GetVideoFrameCount();
            log.debug("\u89c6\u9891\u603b\u5e27\u6570\uff1a{}\uff0c\u68c0\u6d4b\u5e27\u6570\uff1a{}", (Object)totalFrames, (Object)videoFrameCountConfig);
            if (totalFrames < videoFrameCountConfig) {
                R r = R.fail((Integer)1001, (String)"\u89c6\u9891\u5e27\u6570\u4f4e\u4e8e\u68c0\u6d4b\u5e27\u6570");
                return r;
            }
            for (int frameIndex = 0; frameIndex < totalFrames; ++frameIndex) {
                if (frameIndex >= this.config.getMaxVideoDetectFrames()) {
                    R e = R.fail((Integer)10002, (String)("\u8d85\u51fa\u6700\u5927\u68c0\u6d4b\u5e27\u6570\uff1a" + this.config.getMaxVideoDetectFrames()));
                    return e;
                }
                Frame frame = grabber.grabImage();
                if (frame == null) continue;
                BufferedImage bufferedImage = Java2DFrameUtils.toBufferedImage((Frame)frame);
                Image image = SmartImageFactory.getInstance().fromBufferedImage(bufferedImage);
                R<LivenessResult> livenessStatus = this.detectTopFace(image, false);
                if (!livenessStatus.isSuccess()) {
                    log.debug("\u7b2c" + frameIndex + "\u5e27\u5904\u7406\u5931\u8d25\uff1a" + livenessStatus.getMessage());
                    continue;
                }
                if (((LivenessResult)livenessStatus.getData()).getStatus() == LivenessStatus.DETECTING) continue;
                R<LivenessResult> r = livenessStatus;
                return r;
            }
            grabber.stop();
        }
        catch (FFmpegFrameGrabber.Exception e) {
            throw new FaceException(e);
        }
        catch (Exception e) {
            throw new FaceException(e);
        }
        finally {
            if (faceAntiSpoofing != null) {
                try {
                    this.faceAntiSpoofingPool.returnObject((Object)faceAntiSpoofing);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return R.fail((Integer)1000, (String)"\u6709\u6548\u5e27\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u5b8c\u6210\u6d3b\u4f53\u68c0\u6d4b");
    }

    /*
     * Exception decompiling
     */
    @Override
    public R<DetectionResponse> detect(Image image) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[TRYBLOCK]], but top level block is 45[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public R<List<LivenessResult>> detect(Image image, DetectionResponse faceDetectionResponse) {
        if (Objects.isNull(faceDetectionResponse) || Objects.isNull(faceDetectionResponse.getDetectionInfoList()) || faceDetectionResponse.getDetectionInfoList().isEmpty()) {
            return R.fail((R.Status)R.Status.NO_FACE_DETECTED);
        }
        ArrayList<Object> livenessStatusList = new ArrayList<Object>();
        for (DetectionInfo detectionInfo : faceDetectionResponse.getDetectionInfoList()) {
            FaceInfo faceInfo = detectionInfo.getFaceInfo();
            if (Objects.isNull(faceInfo) || Objects.isNull(faceInfo.getKeyPoints())) {
                return R.fail((Integer)R.Status.Unknown.getCode(), (String)"\u672a\u68c0\u6d4b\u5230\u4eba\u8138\u5173\u952e\u70b9");
            }
            R<LivenessResult> result = this.detect(image, detectionInfo.getDetectionRectangle(), detectionInfo.getFaceInfo().getKeyPoints());
            if (!result.isSuccess()) {
                return R.fail((Integer)result.getCode(), (String)result.getMessage());
            }
            livenessStatusList.add(result.getData());
        }
        return R.ok(livenessStatusList);
    }

    @Override
    public R<LivenessResult> detect(Image image, DetectionRectangle faceDetectionRectangle, List<Point> keyPoints) {
        return this.detect(image, faceDetectionRectangle, keyPoints, true);
    }

    @Override
    public R<LivenessResult> detectTopFace(Image image) {
        return this.detectTopFace(image, true);
    }

    /*
     * Loose catch block
     */
    private R<LivenessResult> detectTopFace(Image image, boolean isImage) {
        R<LivenessResult> r;
        FaceDetector detectPredictor;
        FaceLandmarker faceLandmarker;
        FaceAntiSpoofing faceAntiSpoofing;
        block54: {
            R<LivenessResult> detectionResponseR;
            R<DetectionResponse> faceDetectionResponse;
            block52: {
                R seetaResult2222222222;
                block53: {
                    block48: {
                        R r2;
                        block51: {
                            SeetaRect[] seetaResult2222222222;
                            SeetaImageData imageData;
                            block49: {
                                R r3;
                                block50: {
                                    faceAntiSpoofing = null;
                                    faceLandmarker = null;
                                    detectPredictor = null;
                                    if (!Objects.isNull(this.config.getDetectModel())) break block48;
                                    detectPredictor = (FaceDetector)this.faceDetectorPool.borrowObject();
                                    faceLandmarker = (FaceLandmarker)this.faceLandmarkerPool.borrowObject();
                                    faceAntiSpoofing = (FaceAntiSpoofing)this.faceAntiSpoofingPool.borrowObject();
                                    imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
                                    imageData.data = ImageUtils.getMatrixBGR((Image)image);
                                    seetaResult2222222222 = detectPredictor.Detect(imageData);
                                    if (!Objects.isNull(seetaResult2222222222)) break block49;
                                    r3 = R.fail((R.Status)R.Status.NO_FACE_DETECTED);
                                    if (detectPredictor == null) break block50;
                                    try {
                                        this.faceDetectorPool.returnObject((Object)detectPredictor);
                                    }
                                    catch (Exception e) {
                                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                                    }
                                }
                                if (faceAntiSpoofing != null) {
                                    try {
                                        this.faceAntiSpoofingPool.returnObject((Object)faceAntiSpoofing);
                                    }
                                    catch (Exception e) {
                                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                                    }
                                }
                                if (faceLandmarker != null) {
                                    try {
                                        this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
                                    }
                                    catch (Exception e) {
                                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                                    }
                                }
                                return r3;
                            }
                            SeetaPointF[] landmarks = new SeetaPointF[faceLandmarker.number()];
                            faceLandmarker.mark(imageData, seetaResult2222222222[0], landmarks);
                            FaceAntiSpoofing.Status status = null;
                            status = isImage ? faceAntiSpoofing.Predict(imageData, seetaResult2222222222[0], landmarks) : faceAntiSpoofing.PredictVideo(imageData, seetaResult2222222222[0], landmarks);
                            r2 = R.ok((Object)new LivenessResult(Seetaface6Utils.convertToLivenessStatus(status)));
                            if (detectPredictor == null) break block51;
                            try {
                                this.faceDetectorPool.returnObject((Object)detectPredictor);
                            }
                            catch (Exception e) {
                                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                            }
                        }
                        if (faceAntiSpoofing != null) {
                            try {
                                this.faceAntiSpoofingPool.returnObject((Object)faceAntiSpoofing);
                            }
                            catch (Exception e) {
                                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                            }
                        }
                        if (faceLandmarker != null) {
                            try {
                                this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
                            }
                            catch (Exception e) {
                                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                            }
                        }
                        return r2;
                    }
                    faceDetectionResponse = this.config.getDetectModel().detect(image);
                    if (!Objects.isNull(faceDetectionResponse.getData()) && !Objects.isNull(((DetectionResponse)faceDetectionResponse.getData()).getDetectionInfoList()) && !((DetectionResponse)faceDetectionResponse.getData()).getDetectionInfoList().isEmpty()) break block52;
                    seetaResult2222222222 = R.fail((R.Status)R.Status.NO_FACE_DETECTED);
                    if (detectPredictor == null) break block53;
                    try {
                        this.faceDetectorPool.returnObject((Object)detectPredictor);
                    }
                    catch (Exception e) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    }
                }
                if (faceAntiSpoofing != null) {
                    try {
                        this.faceAntiSpoofingPool.returnObject((Object)faceAntiSpoofing);
                    }
                    catch (Exception e) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    }
                }
                if (faceLandmarker != null) {
                    try {
                        this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
                    }
                    catch (Exception e) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    }
                }
                return seetaResult2222222222;
            }
            DetectionInfo detectionInfo = (DetectionInfo)((DetectionResponse)faceDetectionResponse.getData()).getDetectionInfoList().get(0);
            r = detectionResponseR = this.detect(image, detectionInfo.getDetectionRectangle(), detectionInfo.getFaceInfo().getKeyPoints(), isImage);
            if (detectPredictor == null) break block54;
            try {
                this.faceDetectorPool.returnObject((Object)detectPredictor);
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
        }
        if (faceAntiSpoofing != null) {
            try {
                this.faceAntiSpoofingPool.returnObject((Object)faceAntiSpoofing);
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
        }
        if (faceLandmarker != null) {
            try {
                this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
        }
        return r;
        catch (Exception e) {
            try {
                throw new FaceException("\u6d3b\u4f53\u68c0\u6d4b\u9519\u8bef", e);
            }
            catch (Throwable throwable) {
                if (detectPredictor != null) {
                    try {
                        this.faceDetectorPool.returnObject(detectPredictor);
                    }
                    catch (Exception e2) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e2);
                    }
                }
                if (faceAntiSpoofing != null) {
                    try {
                        this.faceAntiSpoofingPool.returnObject(faceAntiSpoofing);
                    }
                    catch (Exception e3) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e3);
                    }
                }
                if (faceLandmarker != null) {
                    try {
                        this.faceLandmarkerPool.returnObject(faceLandmarker);
                    }
                    catch (Exception e4) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e4);
                    }
                }
                throw throwable;
            }
        }
    }

    @Override
    public R<LivenessResult> detectVideo(InputStream videoInputStream) {
        if (Objects.isNull(videoInputStream)) {
            throw new FaceException("\u89c6\u9891\u65e0\u6548");
        }
        return this.detectVideo(new FFmpegFrameGrabber(videoInputStream));
    }

    @Override
    public R<LivenessResult> detectVideo(String videoPath) {
        if (!FileUtils.isFileExists((String)videoPath)) {
            throw new FaceException("\u89c6\u9891\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return this.detectVideo(new FFmpegFrameGrabber(videoPath));
    }

    public FaceDetectorPool getFaceDetectorPool() {
        return this.faceDetectorPool;
    }

    public FaceAntiSpoofingPool getFaceAntiSpoofingPool() {
        return this.faceAntiSpoofingPool;
    }

    public FaceLandmarkerPool getFaceLandmarkerPool() {
        return this.faceLandmarkerPool;
    }

    @Override
    public void close() throws Exception {
        if (this.fromFactory) {
            LivenessModelFactory.removeFromCache(this.config.getModelEnum());
        }
        try {
            if (this.faceDetectorPool != null) {
                this.faceDetectorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.faceAntiSpoofingPool != null) {
                this.faceAntiSpoofingPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.faceLandmarkerPool != null) {
                this.faceLandmarkerPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void setFromFactory(boolean fromFactory) {
        this.fromFactory = fromFactory;
    }

    public boolean isFromFactory() {
        return this.fromFactory;
    }

    static {
        OpenCV.loadLocally();
    }
}

