/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.model.liveness;

import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.engine.Engine;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.Translator;
import ai.djl.util.Progress;
import cn.smartjavaai.common.entity.DetectionRectangle;
import cn.smartjavaai.common.entity.R;
import cn.smartjavaai.common.entity.face.LivenessResult;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.common.enums.face.LivenessStatus;
import cn.smartjavaai.common.pool.PredictorFactory;
import cn.smartjavaai.common.preprocess.DJLImagePreprocessor;
import cn.smartjavaai.common.utils.ArrayUtils;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.face.config.LivenessConfig;
import cn.smartjavaai.face.constant.MiniVisionConstant;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.factory.LivenessModelFactory;
import cn.smartjavaai.face.model.liveness.CommonLivenessModel;
import cn.smartjavaai.face.model.liveness.translator.MiniVisionTranslator;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniVisionLivenessModel
extends CommonLivenessModel {
    private static final Logger log = LoggerFactory.getLogger(MiniVisionLivenessModel.class);
    private static final String SE_MODEL_PATH_KEY = "seModelPath";
    private GenericObjectPool<Predictor<Image, float[]>> predictorPool;
    private GenericObjectPool<Predictor<Image, float[]>> sePredictorPool;
    private ModelStrategy modelStrategy;
    private ZooModel<Image, float[]> model;
    private ZooModel<Image, float[]> seModel;
    private boolean fromFactory = false;

    @Override
    public void loadModel(LivenessConfig config) {
        if (Objects.isNull((Object)config)) {
            throw new FaceException("config\u4e3anull");
        }
        String seModelPath = (String)config.getCustomParam(SE_MODEL_PATH_KEY, String.class);
        if (StringUtils.isBlank((CharSequence)config.getModelPath()) && StringUtils.isBlank((CharSequence)seModelPath)) {
            throw new FaceException("modelPath \u548c seModelPath \u81f3\u5c11\u6709\u4e00\u4e2a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.config = config;
        Float realityThreshold = Objects.isNull(config.getRealityThreshold()) ? MiniVisionConstant.REALITY_THRESHOLD : config.getRealityThreshold();
        this.config.setRealityThreshold(realityThreshold);
        Device device = null;
        if (!Objects.isNull(config.getDevice())) {
            Device device2 = device = config.getDevice() == DeviceEnum.CPU ? Device.cpu() : Device.gpu((int)config.getGpuId());
        }
        this.modelStrategy = StringUtils.isNotBlank((CharSequence)config.getModelPath()) && StringUtils.isBlank((CharSequence)seModelPath) ? ModelStrategy.MINIFASNET_V2 : (StringUtils.isBlank((CharSequence)config.getModelPath()) && StringUtils.isNotBlank((CharSequence)seModelPath) ? ModelStrategy.MINIFASNET_V1_SE : ModelStrategy.FUSION);
        if (this.modelStrategy == ModelStrategy.MINIFASNET_V2 || this.modelStrategy == ModelStrategy.FUSION) {
            Criteria criteria = Criteria.builder().optEngine("OnnxRuntime").setTypes(Image.class, float[].class).optModelPath(Paths.get(config.getModelPath(), new String[0])).optTranslator((Translator)new MiniVisionTranslator()).optProgress((Progress)new ProgressBar()).optDevice(device).build();
            try {
                this.model = criteria.loadModel();
                this.predictorPool = new GenericObjectPool((PooledObjectFactory)new PredictorFactory(this.model));
            }
            catch (MalformedModelException | ModelNotFoundException | IOException e) {
                throw new FaceException("MiniFASNetV2\u6a21\u578b\u52a0\u8f7d\u5931\u8d25", e);
            }
        }
        if (this.modelStrategy == ModelStrategy.MINIFASNET_V1_SE || this.modelStrategy == ModelStrategy.FUSION) {
            Criteria seCriteria = Criteria.builder().optEngine("OnnxRuntime").setTypes(Image.class, float[].class).optModelPath(Paths.get(seModelPath, new String[0])).optTranslator((Translator)new MiniVisionTranslator()).optProgress((Progress)new ProgressBar()).optDevice(device).build();
            try {
                this.seModel = seCriteria.loadModel();
                this.sePredictorPool = new GenericObjectPool((PooledObjectFactory)new PredictorFactory(this.seModel));
            }
            catch (MalformedModelException | ModelNotFoundException | IOException e) {
                throw new FaceException("MiniFASNetV1SE\u6a21\u578b\u52a0\u8f7d\u5931\u8d25", e);
            }
        }
        int predictorPoolSize = config.getPredictorPoolSize();
        if (config.getPredictorPoolSize() <= 0) {
            predictorPoolSize = Runtime.getRuntime().availableProcessors();
        }
        this.predictorPool.setMaxTotal(predictorPoolSize);
        this.sePredictorPool.setMaxTotal(predictorPoolSize);
        log.debug("\u5f53\u524d\u8bbe\u5907: " + this.model.getNDManager().getDevice());
        log.debug("\u5f53\u524d\u5f15\u64ce: " + Engine.getInstance().getEngineName());
        log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + predictorPoolSize);
    }

    /*
     * Loose catch block
     */
    @Override
    public R<LivenessResult> detect(Image image, DetectionRectangle faceDetectionRectangle) {
        R r;
        Predictor sePredictor;
        Predictor predictor;
        block38: {
            BigDecimal avgSocre;
            block36: {
                R r2;
                block37: {
                    Image processedImage;
                    predictor = null;
                    sePredictor = null;
                    float[] result = null;
                    float[] seResult = null;
                    if (Objects.nonNull(this.predictorPool)) {
                        processedImage = new DJLImagePreprocessor(image, faceDetectionRectangle).setExtendRatio(2.7f).enableSquarePadding(true).enableScaling(true).setTargetSize(80).process();
                        predictor = (Predictor)this.predictorPool.borrowObject();
                        result = (float[])predictor.predict((Object)processedImage);
                        ImageUtils.releaseOpenCVMat((Image)processedImage);
                    }
                    if (Objects.nonNull(this.sePredictorPool)) {
                        processedImage = new DJLImagePreprocessor(image, faceDetectionRectangle).setExtendRatio(4.0f).enableSquarePadding(true).enableScaling(true).setTargetSize(80).process();
                        sePredictor = (Predictor)this.sePredictorPool.borrowObject();
                        seResult = (float[])sePredictor.predict((Object)processedImage);
                        ImageUtils.releaseOpenCVMat((Image)processedImage);
                    }
                    if (Objects.isNull(result) && Objects.isNull(seResult)) {
                        throw new FaceException("\u6d3b\u4f53\u68c0\u6d4b\u9519\u8bef");
                    }
                    int maxIndex = ArrayUtils.sumAndFindMaxIndex(result, seResult, (int)3);
                    BigDecimal score = Objects.isNull(result) ? BigDecimal.ZERO : BigDecimal.valueOf((double)result[maxIndex]);
                    BigDecimal seScore = Objects.isNull(seResult) ? BigDecimal.ZERO : BigDecimal.valueOf((double)seResult[maxIndex]);
                    avgSocre = score.add(seScore).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP);
                    if (maxIndex != 1) break block36;
                    LivenessStatus livenessStatus = avgSocre.floatValue() > this.config.getRealityThreshold().floatValue() ? LivenessStatus.LIVE : LivenessStatus.NON_LIVE;
                    r2 = R.ok((Object)new LivenessResult(livenessStatus, avgSocre.floatValue()));
                    if (predictor == null) break block37;
                    try {
                        this.predictorPool.returnObject((Object)predictor);
                    }
                    catch (Exception e) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                        try {
                            predictor.close();
                        }
                        catch (Exception ex) {
                            log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                        }
                    }
                }
                if (sePredictor != null) {
                    try {
                        this.sePredictorPool.returnObject((Object)sePredictor);
                    }
                    catch (Exception e) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                        try {
                            sePredictor.close();
                        }
                        catch (Exception ex) {
                            log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                        }
                    }
                }
                return r2;
            }
            r = R.ok((Object)new LivenessResult(LivenessStatus.NON_LIVE, BigDecimal.ONE.subtract(avgSocre).floatValue()));
            if (predictor == null) break block38;
            try {
                this.predictorPool.returnObject((Object)predictor);
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                try {
                    predictor.close();
                }
                catch (Exception ex) {
                    log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                }
            }
        }
        if (sePredictor != null) {
            try {
                this.sePredictorPool.returnObject((Object)sePredictor);
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                try {
                    sePredictor.close();
                }
                catch (Exception ex) {
                    log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                }
            }
        }
        return r;
        catch (Exception e) {
            try {
                throw new FaceException("\u6d3b\u4f53\u68c0\u6d4b\u9519\u8bef", e);
            }
            catch (Throwable throwable) {
                if (predictor != null) {
                    try {
                        this.predictorPool.returnObject(predictor);
                    }
                    catch (Exception e2) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e2);
                        try {
                            predictor.close();
                        }
                        catch (Exception ex) {
                            log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                        }
                    }
                }
                if (sePredictor != null) {
                    try {
                        this.sePredictorPool.returnObject(sePredictor);
                    }
                    catch (Exception e3) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e3);
                        try {
                            sePredictor.close();
                        }
                        catch (Exception ex) {
                            log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                        }
                    }
                }
                throw throwable;
            }
        }
    }

    public GenericObjectPool<Predictor<Image, float[]>> getPredictorPool() {
        return this.predictorPool;
    }

    public GenericObjectPool<Predictor<Image, float[]>> getSePredictorPool() {
        return this.sePredictorPool;
    }

    @Override
    public void close() throws Exception {
        if (this.fromFactory) {
            LivenessModelFactory.removeFromCache(this.config.getModelEnum());
        }
        try {
            if (this.predictorPool != null) {
                this.predictorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.sePredictorPool != null) {
                this.sePredictorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed sePredictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.model != null) {
                this.model.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed model \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.seModel != null) {
                this.seModel.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed model \u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void setFromFactory(boolean fromFactory) {
        this.fromFactory = fromFactory;
    }

    @Override
    public boolean isFromFactory() {
        return this.fromFactory;
    }

    protected static enum ModelStrategy {
        MINIFASNET_V2,
        MINIFASNET_V1_SE,
        FUSION;

    }
}

