/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.model.facerec.translator;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.transform.Normalize;
import ai.djl.modality.cv.transform.Resize;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.DataType;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import cn.smartjavaai.face.model.facerec.FaceRecPreprocessConfig;

public class CommonFaceRecTranslator
implements Translator<Image, float[]> {
    private FaceRecPreprocessConfig preprocessConfig;

    public CommonFaceRecTranslator(FaceRecPreprocessConfig preprocessConfig) {
        this.preprocessConfig = preprocessConfig;
    }

    public NDList processInput(TranslatorContext ctx, Image input) {
        Pipeline pipeline;
        NDArray array = input.toNDArray(ctx.getNDManager(), this.preprocessConfig.getImageFlag());
        NDList ndList = null;
        if (this.preprocessConfig.isUsePipeline()) {
            pipeline = new Pipeline();
            if (input.getWidth() != this.preprocessConfig.getInputWidth() || input.getHeight() != this.preprocessConfig.getInputHeight()) {
                pipeline.add((Transform)new Resize(this.preprocessConfig.getInputWidth(), this.preprocessConfig.getInputHeight()));
            }
            pipeline.add((Transform)new ToTensor());
            if (this.preprocessConfig.isNormalize()) {
                pipeline.add((Transform)new Normalize(this.preprocessConfig.getMean(), this.preprocessConfig.getStd()));
            }
        } else {
            if (input.getWidth() != this.preprocessConfig.getInputWidth() || input.getHeight() != this.preprocessConfig.getInputHeight()) {
                array = NDImageUtils.resize((NDArray)array, (int)this.preprocessConfig.getInputWidth(), (int)this.preprocessConfig.getInputHeight());
            }
            array = array.toType(DataType.FLOAT32, false);
            if (this.preprocessConfig.isNormalize()) {
                array = array.sub((Number)Float.valueOf(this.preprocessConfig.getMean()[0])).div((Number)Float.valueOf(this.preprocessConfig.getStd()[0]));
            }
            array = array.transpose(new int[]{2, 0, 1});
            return new NDList(new NDArray[]{array});
        }
        ndList = pipeline.transform(new NDList(new NDArray[]{array}));
        return ndList;
    }

    public float[] processOutput(TranslatorContext ctx, NDList list) {
        NDArray embedding = (NDArray)list.get(this.preprocessConfig.getOutputIndex());
        embedding = embedding.div(embedding.norm());
        return embedding.toFloatArray();
    }

    public Batchifier getBatchifier() {
        return Batchifier.STACK;
    }
}

