/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.model.facerec;

import ai.djl.modality.cv.Image;
import java.util.Arrays;

public class FaceRecPreprocessConfig {
    private int inputWidth;
    private int inputHeight;
    private Image.Flag imageFlag;
    private boolean usePipeline;
    private boolean normalize;
    private float[] mean;
    private float[] std;
    private int outputIndex;

    private FaceRecPreprocessConfig(Builder builder) {
        this.inputWidth = builder.inputWidth;
        this.inputHeight = builder.inputHeight;
        this.imageFlag = builder.imageFlag;
        this.usePipeline = builder.usePipeline;
        this.normalize = builder.normalize;
        this.mean = builder.mean;
        this.std = builder.std;
        this.outputIndex = builder.outputIndex;
    }

    public int getInputWidth() {
        return this.inputWidth;
    }

    public int getInputHeight() {
        return this.inputHeight;
    }

    public Image.Flag getImageFlag() {
        return this.imageFlag;
    }

    public boolean isUsePipeline() {
        return this.usePipeline;
    }

    public boolean isNormalize() {
        return this.normalize;
    }

    public float[] getMean() {
        return this.mean;
    }

    public float[] getStd() {
        return this.std;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public void setInputWidth(int inputWidth) {
        this.inputWidth = inputWidth;
    }

    public void setInputHeight(int inputHeight) {
        this.inputHeight = inputHeight;
    }

    public void setImageFlag(Image.Flag imageFlag) {
        this.imageFlag = imageFlag;
    }

    public void setUsePipeline(boolean usePipeline) {
        this.usePipeline = usePipeline;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public void setMean(float[] mean) {
        this.mean = mean;
    }

    public void setStd(float[] std) {
        this.std = std;
    }

    public void setOutputIndex(int outputIndex) {
        this.outputIndex = outputIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FaceRecPreprocessConfig)) {
            return false;
        }
        FaceRecPreprocessConfig other = (FaceRecPreprocessConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInputWidth() != other.getInputWidth()) {
            return false;
        }
        if (this.getInputHeight() != other.getInputHeight()) {
            return false;
        }
        Image.Flag this$imageFlag = this.getImageFlag();
        Image.Flag other$imageFlag = other.getImageFlag();
        if (this$imageFlag == null ? other$imageFlag != null : !this$imageFlag.equals(other$imageFlag)) {
            return false;
        }
        if (this.isUsePipeline() != other.isUsePipeline()) {
            return false;
        }
        if (this.isNormalize() != other.isNormalize()) {
            return false;
        }
        if (!Arrays.equals(this.getMean(), other.getMean())) {
            return false;
        }
        if (!Arrays.equals(this.getStd(), other.getStd())) {
            return false;
        }
        return this.getOutputIndex() == other.getOutputIndex();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FaceRecPreprocessConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInputWidth();
        result = result * 59 + this.getInputHeight();
        Image.Flag $imageFlag = this.getImageFlag();
        result = result * 59 + ($imageFlag == null ? 43 : $imageFlag.hashCode());
        result = result * 59 + (this.isUsePipeline() ? 79 : 97);
        result = result * 59 + (this.isNormalize() ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.getMean());
        result = result * 59 + Arrays.hashCode(this.getStd());
        result = result * 59 + this.getOutputIndex();
        return result;
    }

    public String toString() {
        return "FaceRecPreprocessConfig(inputWidth=" + this.getInputWidth() + ", inputHeight=" + this.getInputHeight() + ", imageFlag=" + this.getImageFlag() + ", usePipeline=" + this.isUsePipeline() + ", normalize=" + this.isNormalize() + ", mean=" + Arrays.toString(this.getMean()) + ", std=" + Arrays.toString(this.getStd()) + ", outputIndex=" + this.getOutputIndex() + ")";
    }

    public static class Builder {
        private int inputWidth = 112;
        private int inputHeight = 112;
        private Image.Flag imageFlag = Image.Flag.COLOR;
        private boolean usePipeline = true;
        private boolean normalize = true;
        private float[] mean = new float[]{0.5f, 0.5f, 0.5f};
        private float[] std = new float[]{0.5f, 0.5f, 0.5f};
        private int outputIndex;

        public Builder inputSize(int width, int height) {
            this.inputWidth = width;
            this.inputHeight = height;
            return this;
        }

        public Builder imageFlag(Image.Flag flag) {
            this.imageFlag = flag;
            return this;
        }

        public Builder usePipeline(boolean usePipeline) {
            this.usePipeline = usePipeline;
            return this;
        }

        public Builder normalize(boolean normalize) {
            this.normalize = normalize;
            return this;
        }

        public Builder mean(float ... mean) {
            this.mean = mean;
            return this;
        }

        public Builder std(float ... std) {
            this.std = std;
            return this;
        }

        public Builder outputIndex(int outputIndex) {
            this.outputIndex = outputIndex;
            return this;
        }

        public FaceRecPreprocessConfig build() {
            return new FaceRecPreprocessConfig(this);
        }
    }
}

