/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.model.facedect.criterial;

import ai.djl.Device;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.repository.zoo.Criteria;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.Translator;
import ai.djl.util.Progress;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.face.config.FaceDetConfig;
import cn.smartjavaai.face.constant.RetinaFaceConstant;
import cn.smartjavaai.face.constant.UltraLightFastGenericFaceConstant;
import cn.smartjavaai.face.enums.FaceDetModelEnum;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.translator.FaceDetectionTranslator;
import cn.smartjavaai.face.translator.YoloV5FaceTranslator;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class FaceDetCriteriaFactory {
    public static Criteria<Image, DetectedObjects> createCriteria(FaceDetConfig config) {
        Device device = null;
        if (!Objects.isNull(config.getDevice())) {
            device = config.getDevice() == DeviceEnum.CPU ? Device.cpu() : Device.gpu((int)config.getGpuId());
        }
        Translator<Image, DetectedObjects> translator = FaceDetCriteriaFactory.getTranslator(config);
        if (StringUtils.isBlank((CharSequence)config.getModelEnum().getModelUrl()) && StringUtils.isBlank((CharSequence)config.getModelPath())) {
            throw new FaceException("\u8bf7\u6307\u5b9a\u6a21\u578b\u8def\u5f84");
        }
        Criteria criteria = Criteria.builder().setTypes(Image.class, DetectedObjects.class).optModelUrls(StringUtils.isNotBlank((CharSequence)config.getModelPath()) ? null : config.getModelEnum().getModelUrl()).optModelPath(StringUtils.isNotBlank((CharSequence)config.getModelPath()) ? Paths.get(config.getModelPath(), new String[0]) : null).optTranslator(translator).optDevice(device).optProgress((Progress)new ProgressBar()).optEngine(config.getModelEnum().getEngine()).build();
        return criteria;
    }

    public static Translator<Image, DetectedObjects> getTranslator(FaceDetConfig config) {
        Object translator = null;
        if (config.getModelEnum() == FaceDetModelEnum.RETINA_FACE || config.getModelEnum() == FaceDetModelEnum.RETINA_FACE_640_ONNX || config.getModelEnum() == FaceDetModelEnum.RETINA_FACE_1080_720_ONNX) {
            translator = new FaceDetectionTranslator(config.getConfidenceThreshold(), config.getNmsThresh(), RetinaFaceConstant.variance, 5000, RetinaFaceConstant.scales, RetinaFaceConstant.steps, config.getModelEnum().getInputWidth(), config.getModelEnum().getInputHeight());
        } else if (config.getModelEnum() == FaceDetModelEnum.ULTRA_LIGHT_FAST_GENERIC_FACE) {
            translator = new FaceDetectionTranslator(config.getConfidenceThreshold(), config.getNmsThresh(), UltraLightFastGenericFaceConstant.variance, 5000, UltraLightFastGenericFaceConstant.scales, UltraLightFastGenericFaceConstant.steps, config.getModelEnum().getInputWidth(), config.getModelEnum().getInputHeight());
        } else if (config.getModelEnum() == FaceDetModelEnum.YOLOV5_FACE_640 || config.getModelEnum() == FaceDetModelEnum.YOLOV5_FACE_320) {
            translator = YoloV5FaceTranslator.builder().setImageSize(config.getModelEnum().getInputWidth(), config.getModelEnum().getInputWidth()).build();
        }
        return translator;
    }
}

