/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.model.facedect;

import ai.djl.modality.cv.Image;
import cn.smartjavaai.common.cv.SmartImageFactory;
import cn.smartjavaai.common.entity.DetectionResponse;
import cn.smartjavaai.common.entity.R;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.common.utils.Base64ImageUtils;
import cn.smartjavaai.common.utils.BufferedImageUtils;
import cn.smartjavaai.common.utils.FileUtils;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.face.config.FaceDetConfig;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.factory.FaceDetModelFactory;
import cn.smartjavaai.face.model.facedect.FaceDetModel;
import cn.smartjavaai.face.seetaface.NativeLoader;
import cn.smartjavaai.face.utils.FaceUtils;
import com.seeta.pool.FaceDetectorPool;
import com.seeta.pool.FaceLandmarkerPool;
import com.seeta.pool.SeetaConfSetting;
import com.seeta.sdk.FaceDetector;
import com.seeta.sdk.FaceLandmarker;
import com.seeta.sdk.SeetaDevice;
import com.seeta.sdk.SeetaImageData;
import com.seeta.sdk.SeetaModelSetting;
import com.seeta.sdk.SeetaPointF;
import com.seeta.sdk.SeetaRect;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeetaFace6FaceDetModel
implements FaceDetModel {
    private static final Logger log = LoggerFactory.getLogger(SeetaFace6FaceDetModel.class);
    private FaceDetConfig config;
    private FaceDetectorPool faceDetectorPool;
    private FaceLandmarkerPool faceLandmarkerPool;
    private static final double THRESHOLD = 0.9;
    private boolean fromFactory = false;

    @Override
    public void loadModel(FaceDetConfig config) {
        this.config = config;
        if (StringUtils.isBlank((CharSequence)config.getModelPath())) {
            throw new FaceException("modelPath is null");
        }
        NativeLoader.loadNativeLibraries(config.getDevice());
        log.debug("Loading seetaFace6 library successfully.");
        String[] faceDetectorModelPath = new String[]{config.getModelPath() + File.separator + "face_detector.csta"};
        String[] faceLandmarkerModelPath = new String[]{config.getModelPath() + File.separator + "face_landmarker_pts5.csta"};
        SeetaDevice device = SeetaDevice.SEETA_DEVICE_AUTO;
        int gpuId = config.getGpuId();
        if (Objects.nonNull(config.getDevice())) {
            device = config.getDevice() == DeviceEnum.CPU ? SeetaDevice.SEETA_DEVICE_CPU : SeetaDevice.SEETA_DEVICE_GPU;
        }
        try {
            SeetaModelSetting faceDetectorPoolSetting = new SeetaModelSetting(gpuId, faceDetectorModelPath, device);
            SeetaConfSetting faceDetectorPoolConfSetting = new SeetaConfSetting(faceDetectorPoolSetting);
            SeetaModelSetting faceLandmarkerPoolSetting = new SeetaModelSetting(gpuId, faceLandmarkerModelPath, device);
            SeetaConfSetting faceLandmarkerPoolConfSetting = new SeetaConfSetting(faceLandmarkerPoolSetting);
            this.faceDetectorPool = new FaceDetectorPool(faceDetectorPoolConfSetting);
            this.faceLandmarkerPool = new FaceLandmarkerPool(faceLandmarkerPoolConfSetting);
            int predictorPoolSize = config.getPredictorPoolSize();
            if (config.getPredictorPoolSize() <= 0) {
                predictorPoolSize = Runtime.getRuntime().availableProcessors();
            }
            this.faceDetectorPool.setMaxTotal(predictorPoolSize);
            this.faceLandmarkerPool.setMaxTotal(predictorPoolSize);
            log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + predictorPoolSize);
        }
        catch (FileNotFoundException e) {
            throw new FaceException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public R<DetectionResponse> detect(Image image) {
        R r;
        FaceLandmarker faceLandmarker;
        block14: {
            SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
            imageData.data = ImageUtils.getMatrixBGR((Image)image);
            FaceDetector predictor = null;
            faceLandmarker = null;
            try {
                predictor = (FaceDetector)this.faceDetectorPool.borrowObject();
                predictor.set(FaceDetector.Property.PROPERTY_THRESHOLD, this.config.getConfidenceThreshold() > 0.0 ? this.config.getConfidenceThreshold() : 0.9);
                faceLandmarker = (FaceLandmarker)this.faceLandmarkerPool.borrowObject();
                R seetaResult = predictor.Detect(imageData);
                ArrayList<SeetaPointF[]> seetaPointFSList = new ArrayList<SeetaPointF[]>();
                for (SeetaRect seetaRect : seetaResult) {
                    SeetaPointF[] pointFS = new SeetaPointF[faceLandmarker.number()];
                    faceLandmarker.mark(imageData, seetaRect, pointFS);
                    seetaPointFSList.add(pointFS);
                }
                r = R.ok((Object)FaceUtils.convertToDetectionResponse((SeetaRect[])seetaResult, seetaPointFSList));
                if (predictor == null) break block14;
            }
            catch (Exception e) {
                try {
                    throw new FaceException("\u76ee\u6807\u68c0\u6d4b\u9519\u8bef", e);
                }
                catch (Throwable throwable) {
                    if (predictor != null) {
                        try {
                            this.faceDetectorPool.returnObject((Object)predictor);
                        }
                        catch (Exception e2) {
                            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e2);
                        }
                    }
                    if (faceLandmarker == null) throw throwable;
                    try {
                        this.faceLandmarkerPool.returnObject(faceLandmarker);
                        throw throwable;
                    }
                    catch (Exception e3) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e3);
                    }
                    throw throwable;
                }
            }
            try {
                this.faceDetectorPool.returnObject((Object)predictor);
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
        }
        if (faceLandmarker == null) return r;
        try {
            this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
            return r;
        }
        catch (Exception e) {
            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
        }
        return r;
    }

    @Override
    public R<DetectionResponse> detectAndDraw(Image image) {
        R<DetectionResponse> result = this.detect(image);
        if (result.getCode().intValue() != R.Status.SUCCESS.getCode()) {
            return R.fail((Integer)result.getCode(), (String)result.getMessage());
        }
        if (Objects.isNull(result.getData()) || Objects.isNull(((DetectionResponse)result.getData()).getDetectionInfoList()) || ((DetectionResponse)result.getData()).getDetectionInfoList().isEmpty()) {
            return R.fail((R.Status)R.Status.NO_FACE_DETECTED);
        }
        Image drawnImage = ImageUtils.drawBoundingBoxes((Image)image, (DetectionResponse)((DetectionResponse)result.getData()));
        ((DetectionResponse)result.getData()).setDrawnImage(drawnImage);
        return result;
    }

    @Override
    public R<DetectionResponse> detect(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.detect(image);
    }

    @Override
    public R<DetectionResponse> detect(InputStream imageInputStream) {
        if (Objects.isNull(imageInputStream)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(imageInputStream);
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8f93\u5165\u6d41", e);
        }
        return this.detect(image);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public R<DetectionResponse> detect(BufferedImage image) {
        R r;
        FaceLandmarker faceLandmarker;
        block15: {
            if (!BufferedImageUtils.isImageValid((BufferedImage)image)) {
                return R.fail((R.Status)R.Status.INVALID_IMAGE);
            }
            SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
            imageData.data = BufferedImageUtils.getMatrixBGR((BufferedImage)image);
            FaceDetector predictor = null;
            faceLandmarker = null;
            try {
                predictor = (FaceDetector)this.faceDetectorPool.borrowObject();
                predictor.set(FaceDetector.Property.PROPERTY_THRESHOLD, this.config.getConfidenceThreshold() > 0.0 ? this.config.getConfidenceThreshold() : 0.9);
                faceLandmarker = (FaceLandmarker)this.faceLandmarkerPool.borrowObject();
                R seetaResult = predictor.Detect(imageData);
                ArrayList<SeetaPointF[]> seetaPointFSList = new ArrayList<SeetaPointF[]>();
                for (SeetaRect seetaRect : seetaResult) {
                    SeetaPointF[] pointFS = new SeetaPointF[faceLandmarker.number()];
                    faceLandmarker.mark(imageData, seetaRect, pointFS);
                    seetaPointFSList.add(pointFS);
                }
                r = R.ok((Object)FaceUtils.convertToDetectionResponse((SeetaRect[])seetaResult, seetaPointFSList));
                if (predictor == null) break block15;
            }
            catch (Exception e) {
                try {
                    throw new FaceException("\u76ee\u6807\u68c0\u6d4b\u9519\u8bef", e);
                }
                catch (Throwable throwable) {
                    if (predictor != null) {
                        try {
                            this.faceDetectorPool.returnObject((Object)predictor);
                        }
                        catch (Exception e2) {
                            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e2);
                        }
                    }
                    if (faceLandmarker == null) throw throwable;
                    try {
                        this.faceLandmarkerPool.returnObject(faceLandmarker);
                        throw throwable;
                    }
                    catch (Exception e3) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e3);
                    }
                    throw throwable;
                }
            }
            try {
                this.faceDetectorPool.returnObject((Object)predictor);
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
        }
        if (faceLandmarker == null) return r;
        try {
            this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
            return r;
        }
        catch (Exception e) {
            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
        }
        return r;
    }

    @Override
    public R<DetectionResponse> detect(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        try {
            return this.detect(ImageIO.read(new ByteArrayInputStream(imageData)));
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public R<DetectionResponse> detectBase64(String base64Image) {
        if (StringUtils.isBlank((CharSequence)base64Image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        byte[] imageData = Base64ImageUtils.base64ToImage((String)base64Image);
        return this.detect(imageData);
    }

    @Override
    public R<DetectionResponse> detectAndDraw(String imagePath, String outputPath) {
        R<DetectionResponse> r;
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        Image image = null;
        Image drawImage = null;
        try {
            image = SmartImageFactory.getInstance().fromFile(imagePath);
            R<DetectionResponse> result = this.detect(image);
            if (result.getCode().intValue() != R.Status.SUCCESS.getCode()) {
                R r2 = R.fail((Integer)result.getCode(), (String)result.getMessage());
                return r2;
            }
            if (Objects.isNull(result.getData()) || Objects.isNull(((DetectionResponse)result.getData()).getDetectionInfoList()) || ((DetectionResponse)result.getData()).getDetectionInfoList().isEmpty()) {
                R r3 = R.fail((R.Status)R.Status.NO_FACE_DETECTED);
                return r3;
            }
            drawImage = ImageUtils.drawBoundingBoxes((Image)image, (DetectionResponse)((DetectionResponse)result.getData()));
            ImageUtils.save((Image)drawImage, (Path)Paths.get(outputPath, new String[0]), (String)"png");
            r = result;
            ImageUtils.releaseOpenCVMat((Image)image);
        }
        catch (IOException e) {
            throw new FaceException("\u4fdd\u5b58\u56fe\u7247\u5931\u8d25", e);
        }
        finally {
            ImageUtils.releaseOpenCVMat((Image)image);
            ImageUtils.releaseOpenCVMat(drawImage);
        }
        ImageUtils.releaseOpenCVMat((Image)drawImage);
        return r;
    }

    @Override
    public R<BufferedImage> detectAndDraw(BufferedImage sourceImage) {
        if (!BufferedImageUtils.isImageValid((BufferedImage)sourceImage)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        R<DetectionResponse> result = this.detect(sourceImage);
        if (result.getCode().intValue() != R.Status.SUCCESS.getCode()) {
            return R.fail((Integer)result.getCode(), (String)result.getMessage());
        }
        if (Objects.isNull(result.getData()) || Objects.isNull(((DetectionResponse)result.getData()).getDetectionInfoList()) || ((DetectionResponse)result.getData()).getDetectionInfoList().isEmpty()) {
            return R.fail((R.Status)R.Status.NO_FACE_DETECTED);
        }
        BufferedImage drawnImage = BufferedImageUtils.copyBufferedImage((BufferedImage)sourceImage);
        BufferedImageUtils.drawBoundingBoxes((BufferedImage)drawnImage, (DetectionResponse)((DetectionResponse)result.getData()));
        return R.ok((Object)drawnImage);
    }

    public FaceDetectorPool getFaceDetectorPool() {
        return this.faceDetectorPool;
    }

    public FaceLandmarkerPool getFaceLandmarkerPool() {
        return this.faceLandmarkerPool;
    }

    @Override
    public void setFromFactory(boolean fromFactory) {
        this.fromFactory = fromFactory;
    }

    public boolean isFromFactory() {
        return this.fromFactory;
    }

    @Override
    public void close() throws Exception {
        if (this.fromFactory) {
            FaceDetModelFactory.removeFromCache(this.config.getModelEnum());
        }
        try {
            if (this.faceDetectorPool != null) {
                this.faceDetectorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.faceLandmarkerPool != null) {
                this.faceLandmarkerPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
    }
}

