/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.model.facedect;

import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.engine.Engine;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.ndarray.NDList;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.NoopTranslator;
import ai.djl.translate.Translator;
import ai.djl.util.Progress;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.common.pool.PredictorFactory;
import cn.smartjavaai.face.config.FaceDetConfig;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.factory.FaceDetModelFactory;
import cn.smartjavaai.face.model.facedect.CommonFaceDetModel;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtcnnFaceDetModel
extends CommonFaceDetModel {
    private static final Logger log = LoggerFactory.getLogger(MtcnnFaceDetModel.class);
    public ZooModel<NDList, NDList> pNetModel;
    public ZooModel<NDList, NDList> rNetModel;
    public ZooModel<NDList, NDList> oNetModel;
    private GenericObjectPool<Predictor<NDList, NDList>> pnetPredictorPool;
    private GenericObjectPool<Predictor<NDList, NDList>> rnetPredictorPool;
    private GenericObjectPool<Predictor<NDList, NDList>> onetPredictorPool;
    private FaceDetConfig config;
    private boolean fromFactory = false;

    @Override
    public void loadModel(FaceDetConfig config) {
        this.config = config;
        if (StringUtils.isBlank((CharSequence)config.getModelPath())) {
            throw new FaceException("modelPath is null");
        }
        Path modelPath = Paths.get(config.getModelPath(), new String[0]);
        if (!Files.isDirectory(modelPath, new LinkOption[0])) {
            throw new FaceException("MTCNN \u6a21\u578b\u9700\u8981\u6307\u5b9a\u5b58\u653e\u6a21\u578b\u6587\u4ef6\u7684\u76ee\u5f55\u8def\u5f84");
        }
        try {
            Device device = null;
            if (!Objects.isNull(config.getDevice())) {
                device = config.getDevice() == DeviceEnum.CPU ? Device.cpu() : Device.gpu((int)config.getGpuId());
            }
            Path pnetPath = modelPath.resolve("pnet_script.pt");
            Path rnetPath = modelPath.resolve("rnet_script.pt");
            Path onetPath = modelPath.resolve("onet_script.pt");
            this.pNetModel = this.getModel(pnetPath, device);
            this.rNetModel = this.getModel(rnetPath, device);
            this.oNetModel = this.getModel(onetPath, device);
            this.pnetPredictorPool = new GenericObjectPool((PooledObjectFactory)new PredictorFactory(this.pNetModel));
            this.rnetPredictorPool = new GenericObjectPool((PooledObjectFactory)new PredictorFactory(this.rNetModel));
            this.onetPredictorPool = new GenericObjectPool((PooledObjectFactory)new PredictorFactory(this.oNetModel));
            int predictorPoolSize = config.getPredictorPoolSize();
            if (config.getPredictorPoolSize() <= 0) {
                predictorPoolSize = Runtime.getRuntime().availableProcessors();
            }
            this.pnetPredictorPool.setMaxTotal(predictorPoolSize);
            this.rnetPredictorPool.setMaxTotal(predictorPoolSize);
            this.onetPredictorPool.setMaxTotal(predictorPoolSize);
            log.debug("\u5f53\u524d\u8bbe\u5907: " + this.pNetModel.getNDManager().getDevice());
            log.debug("\u5f53\u524d\u5f15\u64ce: " + Engine.getInstance().getEngineName());
            log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + predictorPoolSize);
        }
        catch (MalformedModelException | ModelNotFoundException | IOException e) {
            throw new FaceException("mtcnn\u4eba\u8138\u68c0\u6d4b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25", e);
        }
    }

    public ZooModel<NDList, NDList> getModel(Path modelPath, Device device) throws ModelNotFoundException, MalformedModelException, IOException {
        Criteria criteria = Criteria.builder().setTypes(NDList.class, NDList.class).optTranslator((Translator)new NoopTranslator()).optEngine("PyTorch").optModelPath(modelPath).optProgress((Progress)new ProgressBar()).optDevice(device).build();
        return criteria.loadModel();
    }

    /*
     * Exception decompiling
     */
    @Override
    public DetectedObjects detectCore(Image image) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public GenericObjectPool<Predictor<NDList, NDList>> getPnetPredictorPool() {
        return this.pnetPredictorPool;
    }

    public GenericObjectPool<Predictor<NDList, NDList>> getRnetPredictorPool() {
        return this.rnetPredictorPool;
    }

    public GenericObjectPool<Predictor<NDList, NDList>> getOnetPredictorPool() {
        return this.onetPredictorPool;
    }

    @Override
    public void setFromFactory(boolean fromFactory) {
        this.fromFactory = fromFactory;
    }

    @Override
    public boolean isFromFactory() {
        return this.fromFactory;
    }

    @Override
    public void close() {
        if (this.fromFactory) {
            FaceDetModelFactory.removeFromCache(this.config.getModelEnum());
        }
        try {
            if (this.pnetPredictorPool != null) {
                this.pnetPredictorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.rnetPredictorPool != null) {
                this.rnetPredictorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.onetPredictorPool != null) {
                this.onetPredictorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.pNetModel != null) {
                this.pNetModel.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed model \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.pNetModel != null) {
                this.pNetModel.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed model \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.rNetModel != null) {
                this.rNetModel.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed model \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.oNetModel != null) {
                this.oNetModel.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed model \u5931\u8d25", (Throwable)e);
        }
    }
}

