/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.model.facedect;

import ai.djl.MalformedModelException;
import ai.djl.engine.Engine;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import cn.smartjavaai.common.cv.SmartImageFactory;
import cn.smartjavaai.common.entity.DetectionResponse;
import cn.smartjavaai.common.entity.R;
import cn.smartjavaai.common.pool.PredictorFactory;
import cn.smartjavaai.common.utils.Base64ImageUtils;
import cn.smartjavaai.common.utils.BufferedImageUtils;
import cn.smartjavaai.common.utils.FileUtils;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.face.config.FaceDetConfig;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.factory.FaceDetModelFactory;
import cn.smartjavaai.face.model.facedect.FaceDetModel;
import cn.smartjavaai.face.model.facedect.criterial.FaceDetCriteriaFactory;
import cn.smartjavaai.face.utils.FaceUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.opencv.core.Mat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonFaceDetModel
implements FaceDetModel {
    private static final Logger log = LoggerFactory.getLogger(CommonFaceDetModel.class);
    private GenericObjectPool<Predictor<Image, DetectedObjects>> predictorPool;
    private ZooModel<Image, DetectedObjects> model;
    private FaceDetConfig config;
    private boolean fromFactory = false;

    @Override
    public void loadModel(FaceDetConfig config) {
        Criteria<Image, DetectedObjects> criteria = FaceDetCriteriaFactory.createCriteria(config);
        try {
            this.config = config;
            this.model = criteria.loadModel();
            this.predictorPool = new GenericObjectPool((PooledObjectFactory)new PredictorFactory(this.model));
            int predictorPoolSize = config.getPredictorPoolSize();
            if (config.getPredictorPoolSize() <= 0) {
                predictorPoolSize = Runtime.getRuntime().availableProcessors();
            }
            this.predictorPool.setMaxTotal(predictorPoolSize);
            log.debug("\u5f53\u524d\u8bbe\u5907: " + this.model.getNDManager().getDevice());
            log.debug("\u5f53\u524d\u5f15\u64ce: " + Engine.getInstance().getEngineName());
            log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + predictorPoolSize);
        }
        catch (MalformedModelException | ModelNotFoundException | IOException e) {
            throw new FaceException("\u4eba\u8138\u68c0\u6d4b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25", e);
        }
    }

    @Override
    public R<DetectionResponse> detect(Image image) {
        DetectedObjects detection = this.detectCore(image);
        return R.ok((Object)FaceUtils.convertToDetectionResponse(detection, image));
    }

    @Override
    public R<DetectionResponse> detect(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        Image img = null;
        try {
            img = SmartImageFactory.getInstance().fromFile(Paths.get(imagePath, new String[0]));
            DetectedObjects detection = this.detectCore(img);
            DetectionResponse detectionResponse = FaceUtils.convertToDetectionResponse(detection, img);
            if (detectionResponse == null) {
                R r = R.fail((R.Status)R.Status.NO_FACE_DETECTED);
                return r;
            }
            R r = R.ok((Object)detectionResponse);
            return r;
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u7684\u56fe\u7247", e);
        }
        finally {
            if (img != null && img.getWrappedImage() instanceof Mat) {
                ((Mat)img.getWrappedImage()).release();
            }
        }
    }

    @Override
    public R<DetectionResponse> detect(InputStream imageInputStream) {
        if (Objects.isNull(imageInputStream)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image img = null;
        try {
            img = SmartImageFactory.getInstance().fromInputStream(imageInputStream);
            DetectedObjects detection = this.detectCore(img);
            DetectionResponse detectionResponse = FaceUtils.convertToDetectionResponse(detection, img);
            if (detectionResponse == null) {
                R r = R.fail((R.Status)R.Status.NO_FACE_DETECTED);
                return r;
            }
            R r = R.ok((Object)detectionResponse);
            return r;
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8f93\u5165\u6d41", e);
        }
        finally {
            if (img != null && img.getWrappedImage() instanceof Mat) {
                ((Mat)img.getWrappedImage()).release();
            }
        }
    }

    @Override
    public R<DetectionResponse> detect(BufferedImage image) {
        if (!BufferedImageUtils.isImageValid((BufferedImage)image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image img = null;
        try {
            img = SmartImageFactory.getInstance().fromBufferedImage(image);
            DetectedObjects detection = this.detectCore(img);
            DetectionResponse detectionResponse = FaceUtils.convertToDetectionResponse(detection, img);
            if (detectionResponse == null) {
                R r = R.fail((R.Status)R.Status.NO_FACE_DETECTED);
                return r;
            }
            R r = R.ok((Object)detectionResponse);
            return r;
        }
        catch (Exception e) {
            throw new FaceException(e);
        }
        finally {
            if (img != null && img.getWrappedImage() instanceof Mat) {
                ((Mat)img.getWrappedImage()).release();
            }
        }
    }

    @Override
    public R<DetectionResponse> detect(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        return this.detect(new ByteArrayInputStream(imageData));
    }

    @Override
    public R<DetectionResponse> detectBase64(String base64Image) {
        if (StringUtils.isBlank((CharSequence)base64Image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        byte[] imageData = Base64ImageUtils.base64ToImage((String)base64Image);
        return this.detect(imageData);
    }

    @Override
    public R<DetectionResponse> detectAndDraw(Image image) {
        DetectedObjects detectedObjects = this.detectCore(image);
        if (Objects.isNull(detectedObjects) || detectedObjects.getNumberOfObjects() == 0) {
            return R.fail((R.Status)R.Status.NO_FACE_DETECTED);
        }
        Image drawnImage = ImageUtils.copy((Image)image);
        drawnImage.drawBoundingBoxes(detectedObjects);
        DetectionResponse detectionResponse = FaceUtils.convertToDetectionResponse(detectedObjects, drawnImage);
        detectionResponse.setDrawnImage(drawnImage);
        return R.ok((Object)detectionResponse);
    }

    @Override
    public R<DetectionResponse> detectAndDraw(String imagePath, String outputPath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        Image img = null;
        try {
            img = SmartImageFactory.getInstance().fromFile(Paths.get(imagePath, new String[0]));
            DetectedObjects detectedObjects = this.detectCore(img);
            if (Objects.isNull(detectedObjects) || detectedObjects.getNumberOfObjects() == 0) {
                R r = R.fail((R.Status)R.Status.NO_FACE_DETECTED);
                return r;
            }
            img.drawBoundingBoxes(detectedObjects);
            Path output = Paths.get(outputPath, new String[0]);
            log.debug("Saving to {}", (Object)output.toAbsolutePath().toString());
            img.save(Files.newOutputStream(output, new OpenOption[0]), "png");
            DetectionResponse detectionResponse = FaceUtils.convertToDetectionResponse(detectedObjects, img);
            if (detectionResponse == null) {
                R r = R.fail((R.Status)R.Status.NO_FACE_DETECTED);
                return r;
            }
            R r = R.ok((Object)detectionResponse);
            return r;
        }
        catch (IOException e) {
            throw new FaceException(e);
        }
        finally {
            if (img != null && img.getWrappedImage() instanceof Mat) {
                ((Mat)img.getWrappedImage()).release();
            }
        }
    }

    @Override
    public R<BufferedImage> detectAndDraw(BufferedImage sourceImage) {
        if (!BufferedImageUtils.isImageValid((BufferedImage)sourceImage)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image img = SmartImageFactory.getInstance().fromBufferedImage(sourceImage);
        DetectedObjects detectedObjects = this.detectCore(img);
        if (Objects.isNull(detectedObjects) || detectedObjects.getNumberOfObjects() == 0) {
            return R.fail((R.Status)R.Status.NO_FACE_DETECTED);
        }
        img.drawBoundingBoxes(detectedObjects);
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            img.save((OutputStream)outputStream, "png");
            byte[] imageBytes = outputStream.toByteArray();
            R r = R.ok((Object)ImageIO.read(new ByteArrayInputStream(imageBytes)));
            return r;
        }
        catch (IOException e) {
            throw new FaceException("\u5bfc\u51fa\u56fe\u7247\u5931\u8d25", e);
        }
        finally {
            if (img != null && img.getWrappedImage() instanceof Mat) {
                ((Mat)img.getWrappedImage()).release();
            }
        }
    }

    @Override
    public DetectedObjects detectCore(Image image) {
        Predictor predictor = null;
        try {
            predictor = (Predictor)this.predictorPool.borrowObject();
            DetectedObjects detectedObjects = (DetectedObjects)predictor.predict((Object)image);
            return detectedObjects;
        }
        catch (Exception e) {
            throw new FaceException("\u4eba\u8138\u68c0\u6d4b\u9519\u8bef", e);
        }
        finally {
            if (predictor != null) {
                try {
                    this.predictorPool.returnObject((Object)predictor);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    try {
                        predictor.close();
                    }
                    catch (Exception ex) {
                        log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                    }
                }
            }
        }
    }

    @Override
    public GenericObjectPool<Predictor<Image, DetectedObjects>> getPool() {
        return this.predictorPool;
    }

    @Override
    public void setFromFactory(boolean fromFactory) {
        this.fromFactory = fromFactory;
    }

    public boolean isFromFactory() {
        return this.fromFactory;
    }

    @Override
    public void close() {
        if (this.fromFactory) {
            FaceDetModelFactory.removeFromCache(this.config.getModelEnum());
        }
        try {
            if (this.predictorPool != null) {
                this.predictorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.model != null) {
                this.model.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed model \u5931\u8d25", (Throwable)e);
        }
    }
}

