/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.model.expression;

import ai.djl.MalformedModelException;
import ai.djl.engine.Engine;
import ai.djl.inference.Predictor;
import ai.djl.modality.Classifications;
import ai.djl.modality.cv.Image;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import cn.smartjavaai.common.cv.SmartImageFactory;
import cn.smartjavaai.common.entity.DetectionInfo;
import cn.smartjavaai.common.entity.DetectionRectangle;
import cn.smartjavaai.common.entity.DetectionResponse;
import cn.smartjavaai.common.entity.Point;
import cn.smartjavaai.common.entity.R;
import cn.smartjavaai.common.entity.face.ExpressionResult;
import cn.smartjavaai.common.entity.face.FaceInfo;
import cn.smartjavaai.common.enums.face.FacialExpression;
import cn.smartjavaai.common.pool.PredictorFactory;
import cn.smartjavaai.common.utils.BufferedImageUtils;
import cn.smartjavaai.common.utils.FileUtils;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.face.config.FaceExpressionConfig;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.factory.ExpressionModelFactory;
import cn.smartjavaai.face.model.expression.ExpressionModel;
import cn.smartjavaai.face.model.expression.criterial.EmotionCriteriaFactory;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonEmotionModel
implements ExpressionModel {
    private static final Logger log = LoggerFactory.getLogger(CommonEmotionModel.class);
    private FaceExpressionConfig config;
    private ZooModel<Image, Classifications> model;
    private GenericObjectPool<Predictor<Image, Classifications>> predictorPool;
    private boolean fromFactory = false;

    @Override
    public void loadModel(FaceExpressionConfig config) {
        if (Objects.isNull((Object)config)) {
            throw new FaceException("config\u4e3anull");
        }
        if (StringUtils.isBlank((CharSequence)config.getModelPath())) {
            throw new FaceException("modelPath\u4e3a\u7a7a");
        }
        if (Objects.isNull(config.getDetectModel())) {
            throw new FaceException("\u672a\u6307\u5b9a\u4eba\u8138\u68c0\u6d4b\u6a21\u578b");
        }
        this.config = config;
        Criteria<Image, Classifications> criteria = EmotionCriteriaFactory.createCriteria(config);
        try {
            this.model = criteria.loadModel();
            this.predictorPool = new GenericObjectPool((PooledObjectFactory)new PredictorFactory(this.model));
            int predictorPoolSize = config.getPredictorPoolSize();
            if (config.getPredictorPoolSize() <= 0) {
                predictorPoolSize = Runtime.getRuntime().availableProcessors();
            }
            this.predictorPool.setMaxTotal(predictorPoolSize);
            log.debug("\u5f53\u524d\u8bbe\u5907: " + this.model.getNDManager().getDevice());
            log.debug("\u5f53\u524d\u5f15\u64ce: " + Engine.getInstance().getEngineName());
            log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + predictorPoolSize);
        }
        catch (MalformedModelException | ModelNotFoundException | IOException e) {
            throw new FaceException("DenseNetEmotionModel\u6a21\u578b\u52a0\u8f7d\u5931\u8d25", e);
        }
    }

    /*
     * Exception decompiling
     */
    public Classifications detectCore(Image image, DetectionRectangle faceDetectionRectangle, List<Point> keyPoints) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public R<DetectionResponse> detect(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        Image image = null;
        try {
            R<DetectionResponse> detectionResponseR;
            image = SmartImageFactory.getInstance().fromFile(imagePath);
            R<DetectionResponse> r = detectionResponseR = this.detect(image);
            return r;
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        finally {
            ImageUtils.releaseOpenCVMat((Image)image);
        }
    }

    @Override
    public R<DetectionResponse> detect(BufferedImage image) {
        Image imageDjl = SmartImageFactory.getInstance().fromBufferedImage(image);
        R<DetectionResponse> detectionResponseR = this.detect(imageDjl);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    @Override
    public R<DetectionResponse> detect(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image imageDjl = null;
        try {
            imageDjl = SmartImageFactory.getInstance().fromBytes(imageData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        R<DetectionResponse> detectionResponseR = this.detect(imageDjl);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    @Override
    public R<DetectionResponse> detectBase64(String base64Image) {
        if (StringUtils.isBlank((CharSequence)base64Image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image image = null;
        try {
            R<DetectionResponse> detectionResponseR;
            image = SmartImageFactory.getInstance().fromBase64(base64Image);
            R<DetectionResponse> r = detectionResponseR = this.detect(image);
            return r;
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247", e);
        }
        finally {
            ImageUtils.releaseOpenCVMat((Image)image);
        }
    }

    @Override
    public R<List<ExpressionResult>> detect(String imagePath, DetectionResponse faceDetectionResponse) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        Image image = null;
        try {
            R<List<ExpressionResult>> detectionResponseR;
            image = SmartImageFactory.getInstance().fromFile(imagePath);
            R<List<ExpressionResult>> r = detectionResponseR = this.detect(image, faceDetectionResponse);
            return r;
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        finally {
            ImageUtils.releaseOpenCVMat((Image)image);
        }
    }

    @Override
    public R<List<ExpressionResult>> detect(byte[] imageData, DetectionResponse faceDetectionResponse) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image imageDjl = null;
        try {
            imageDjl = SmartImageFactory.getInstance().fromBytes(imageData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        R<List<ExpressionResult>> detectionResponseR = this.detect(imageDjl, faceDetectionResponse);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    @Override
    public R<List<ExpressionResult>> detect(BufferedImage image, DetectionResponse faceDetectionResponse) {
        Image imageDjl = SmartImageFactory.getInstance().fromBufferedImage(image);
        R<List<ExpressionResult>> detectionResponseR = this.detect(imageDjl, faceDetectionResponse);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    @Override
    public R<List<ExpressionResult>> detectBase64(String base64Image, DetectionResponse faceDetectionResponse) {
        if (StringUtils.isBlank((CharSequence)base64Image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image image = null;
        try {
            R<List<ExpressionResult>> detectionResponseR;
            image = SmartImageFactory.getInstance().fromBase64(base64Image);
            R<List<ExpressionResult>> r = detectionResponseR = this.detect(image, faceDetectionResponse);
            return r;
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247", e);
        }
        finally {
            ImageUtils.releaseOpenCVMat((Image)image);
        }
    }

    @Override
    public R<ExpressionResult> detect(String imagePath, DetectionRectangle faceDetectionRectangle, List<Point> keyPoints) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        Image image = null;
        try {
            R<ExpressionResult> detectionResponseR;
            image = SmartImageFactory.getInstance().fromFile(imagePath);
            R<ExpressionResult> r = detectionResponseR = this.detect(image, faceDetectionRectangle, keyPoints);
            return r;
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        finally {
            ImageUtils.releaseOpenCVMat((Image)image);
        }
    }

    @Override
    public R<ExpressionResult> detect(byte[] imageData, DetectionRectangle faceDetectionRectangle, List<Point> keyPoints) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image imageDjl = null;
        try {
            imageDjl = SmartImageFactory.getInstance().fromBytes(imageData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        R<ExpressionResult> detectionResponseR = this.detect(imageDjl, faceDetectionRectangle, keyPoints);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    @Override
    public R<ExpressionResult> detect(BufferedImage image, DetectionRectangle faceDetectionRectangle, List<Point> keyPoints) {
        if (!BufferedImageUtils.isImageValid((BufferedImage)image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image imageDjl = SmartImageFactory.getInstance().fromBufferedImage(image);
        R<ExpressionResult> detectionResponseR = this.detect(imageDjl, faceDetectionRectangle, keyPoints);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    @Override
    public R<ExpressionResult> detectBase64(String base64Image, DetectionRectangle faceDetectionRectangle, List<Point> keyPoints) {
        if (StringUtils.isBlank((CharSequence)base64Image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image image = null;
        try {
            R<ExpressionResult> detectionResponseR;
            image = SmartImageFactory.getInstance().fromBase64(base64Image);
            R<ExpressionResult> r = detectionResponseR = this.detect(image, faceDetectionRectangle, keyPoints);
            return r;
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247", e);
        }
        finally {
            ImageUtils.releaseOpenCVMat((Image)image);
        }
    }

    @Override
    public R<ExpressionResult> detectTopFace(BufferedImage image) {
        Image imageDjl = SmartImageFactory.getInstance().fromBufferedImage(image);
        R<ExpressionResult> detectionResponseR = this.detectTopFace(imageDjl);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    @Override
    public R<ExpressionResult> detectTopFace(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        Image image = null;
        try {
            R<ExpressionResult> detectionResponseR;
            image = SmartImageFactory.getInstance().fromFile(imagePath);
            R<ExpressionResult> r = detectionResponseR = this.detectTopFace(image);
            return r;
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        finally {
            ImageUtils.releaseOpenCVMat((Image)image);
        }
    }

    @Override
    public R<ExpressionResult> detectTopFace(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image imageDjl = null;
        try {
            imageDjl = SmartImageFactory.getInstance().fromBytes(imageData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        R<ExpressionResult> detectionResponseR = this.detectTopFace(imageDjl);
        ImageUtils.releaseOpenCVMat((Image)imageDjl);
        return detectionResponseR;
    }

    @Override
    public R<ExpressionResult> detectTopFaceBase64(String base64Image) {
        if (StringUtils.isBlank((CharSequence)base64Image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image image = null;
        try {
            R<ExpressionResult> detectionResponseR;
            image = SmartImageFactory.getInstance().fromBase64(base64Image);
            R<ExpressionResult> r = detectionResponseR = this.detectTopFace(image);
            return r;
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247", e);
        }
        finally {
            ImageUtils.releaseOpenCVMat((Image)image);
        }
    }

    @Override
    public R<DetectionResponse> detect(Image image) {
        if (Objects.isNull(this.config.getDetectModel())) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"\u672a\u6307\u5b9a\u68c0\u6d4b\u6a21\u578b");
        }
        R<DetectionResponse> faceDetectionResponse = this.config.getDetectModel().detect(image);
        if (Objects.isNull(faceDetectionResponse.getData()) || Objects.isNull(((DetectionResponse)faceDetectionResponse.getData()).getDetectionInfoList()) || ((DetectionResponse)faceDetectionResponse.getData()).getDetectionInfoList().isEmpty()) {
            return R.fail((R.Status)R.Status.NO_FACE_DETECTED);
        }
        for (DetectionInfo detectionInfo : ((DetectionResponse)faceDetectionResponse.getData()).getDetectionInfoList()) {
            FaceInfo faceInfo = detectionInfo.getFaceInfo();
            if (Objects.isNull(faceInfo) || Objects.isNull(faceInfo.getKeyPoints())) {
                return R.fail((Integer)R.Status.Unknown.getCode(), (String)"\u672a\u68c0\u6d4b\u5230\u4eba\u8138\u5173\u952e\u70b9");
            }
            Classifications classifications = this.detectCore(image, detectionInfo.getDetectionRectangle(), faceInfo.getKeyPoints());
            Classifications.Classification bestClass = classifications.best();
            FacialExpression expression = FacialExpression.fromLabel((String)bestClass.getClassName());
            ExpressionResult result = new ExpressionResult(expression, (float)bestClass.getProbability());
            result.setClassifications(classifications);
            faceInfo.setExpressionResult(result);
        }
        return faceDetectionResponse;
    }

    @Override
    public R<List<ExpressionResult>> detect(Image image, DetectionResponse faceDetectionResponse) {
        if (Objects.isNull(faceDetectionResponse) || Objects.isNull(faceDetectionResponse.getDetectionInfoList()) || faceDetectionResponse.getDetectionInfoList().isEmpty()) {
            R.fail((R.Status)R.Status.NO_FACE_DETECTED);
        }
        ArrayList<ExpressionResult> expressionResults = new ArrayList<ExpressionResult>();
        for (DetectionInfo detectionInfo : faceDetectionResponse.getDetectionInfoList()) {
            FaceInfo faceInfo = detectionInfo.getFaceInfo();
            if (Objects.isNull(faceInfo) || Objects.isNull(faceInfo.getKeyPoints())) {
                return R.fail((Integer)R.Status.Unknown.getCode(), (String)"\u672a\u68c0\u6d4b\u5230\u4eba\u8138\u5173\u952e\u70b9");
            }
            Classifications classifications = this.detectCore(image, detectionInfo.getDetectionRectangle(), faceInfo.getKeyPoints());
            Classifications.Classification bestClass = classifications.best();
            FacialExpression expression = FacialExpression.fromLabel((String)bestClass.getClassName());
            ExpressionResult result = new ExpressionResult(expression, (float)bestClass.getProbability());
            result.setClassifications(classifications);
            expressionResults.add(result);
        }
        return R.ok(expressionResults);
    }

    @Override
    public R<ExpressionResult> detect(Image image, DetectionRectangle faceDetectionRectangle, List<Point> keyPoints) {
        Classifications classifications = this.detectCore(image, faceDetectionRectangle, keyPoints);
        Classifications.Classification bestClass = classifications.best();
        FacialExpression expression = FacialExpression.fromLabel((String)bestClass.getClassName());
        ExpressionResult result = new ExpressionResult(expression, (float)bestClass.getProbability());
        result.setClassifications(classifications);
        return R.ok((Object)result);
    }

    @Override
    public R<ExpressionResult> detectTopFace(Image image) {
        R<DetectionResponse> faceDetectionResponse = this.config.getDetectModel().detect(image);
        if (Objects.isNull(faceDetectionResponse.getData()) || Objects.isNull(((DetectionResponse)faceDetectionResponse.getData()).getDetectionInfoList()) || ((DetectionResponse)faceDetectionResponse.getData()).getDetectionInfoList().isEmpty()) {
            return R.fail((R.Status)R.Status.NO_FACE_DETECTED);
        }
        DetectionInfo detectionInfo = (DetectionInfo)((DetectionResponse)faceDetectionResponse.getData()).getDetectionInfoList().get(0);
        FaceInfo faceInfo = detectionInfo.getFaceInfo();
        if (Objects.isNull(faceInfo) || Objects.isNull(faceInfo.getKeyPoints())) {
            return R.fail((Integer)R.Status.Unknown.getCode(), (String)"\u672a\u68c0\u6d4b\u5230\u4eba\u8138\u5173\u952e\u70b9");
        }
        return this.detect(image, detectionInfo.getDetectionRectangle(), (List<Point>)detectionInfo.getFaceInfo().getKeyPoints());
    }

    @Override
    public GenericObjectPool<Predictor<Image, Classifications>> getPool() {
        return this.predictorPool;
    }

    @Override
    public void setFromFactory(boolean fromFactory) {
        this.fromFactory = fromFactory;
    }

    public boolean isFromFactory() {
        return this.fromFactory;
    }

    @Override
    public void close() {
        if (this.fromFactory) {
            ExpressionModelFactory.removeFromCache(this.config.getModelEnum());
        }
        try {
            if (this.predictorPool != null) {
                this.predictorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.model != null) {
                this.model.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed model \u5931\u8d25", (Throwable)e);
        }
    }
}

