/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.factory;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.face.config.QualityConfig;
import cn.smartjavaai.face.enums.QualityModelEnum;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.model.quality.FaceQualityModel;
import cn.smartjavaai.face.model.quality.Seetaface6QualityModel;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceQualityModelFactory {
    private static final Logger log = LoggerFactory.getLogger(FaceQualityModelFactory.class);
    private static volatile FaceQualityModelFactory instance;
    private static final ConcurrentHashMap<QualityModelEnum, FaceQualityModel> modelMap;
    private static final Map<QualityModelEnum, Class<? extends FaceQualityModel>> registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FaceQualityModelFactory getInstance() {
        if (instance != null) return instance;
        Class<FaceQualityModelFactory> clazz = FaceQualityModelFactory.class;
        synchronized (FaceQualityModelFactory.class) {
            if (instance != null) return instance;
            instance = new FaceQualityModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void registerModel(QualityModelEnum qualityModelEnum, Class<? extends FaceQualityModel> clazz) {
        registry.put(qualityModelEnum, clazz);
    }

    public FaceQualityModel getModel(QualityConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new FaceException("\u672a\u914d\u7f6e\u8d28\u91cf\u8bc4\u4f30\u6a21\u578b");
        }
        return modelMap.computeIfAbsent(config.getModelEnum(), k -> this.createFaceModel(config));
    }

    private FaceQualityModel createFaceModel(QualityConfig config) {
        Class<? extends FaceQualityModel> clazz = registry.get((Object)config.getModelEnum());
        if (clazz == null) {
            throw new FaceException("Unsupported algorithm");
        }
        FaceQualityModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new FaceException(e);
        }
        model.loadModel(config);
        model.setFromFactory(true);
        return model;
    }

    public void closeAll() {
        modelMap.values().forEach(model -> {
            try {
                model.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        modelMap.clear();
    }

    public static void removeFromCache(QualityModelEnum modelEnum) {
        modelMap.remove((Object)modelEnum);
    }

    static {
        modelMap = new ConcurrentHashMap();
        registry = new ConcurrentHashMap<QualityModelEnum, Class<? extends FaceQualityModel>>();
        FaceQualityModelFactory.registerModel(QualityModelEnum.SEETA_FACE6_MODEL, Seetaface6QualityModel.class);
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

