/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.factory;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.face.config.FaceAttributeConfig;
import cn.smartjavaai.face.enums.FaceAttributeModelEnum;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.model.attribute.FaceAttributeModel;
import cn.smartjavaai.face.model.attribute.Seetaface6FaceAttributeModel;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceAttributeModelFactory {
    private static final Logger log = LoggerFactory.getLogger(FaceAttributeModelFactory.class);
    private static volatile FaceAttributeModelFactory instance;
    private static final ConcurrentHashMap<FaceAttributeModelEnum, FaceAttributeModel> modelMap;
    private static final Map<FaceAttributeModelEnum, Class<? extends FaceAttributeModel>> registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FaceAttributeModelFactory getInstance() {
        if (instance != null) return instance;
        Class<FaceAttributeModelFactory> clazz = FaceAttributeModelFactory.class;
        synchronized (FaceAttributeModelFactory.class) {
            if (instance != null) return instance;
            instance = new FaceAttributeModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void registerModel(FaceAttributeModelEnum faceAttributeModelEnum, Class<? extends FaceAttributeModel> clazz) {
        registry.put(faceAttributeModelEnum, clazz);
    }

    public FaceAttributeModel getModel(FaceAttributeConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new FaceException("\u672a\u914d\u7f6e\u6d3b\u4f53\u68c0\u6d4b\u6a21\u578b");
        }
        return modelMap.computeIfAbsent(config.getModelEnum(), k -> this.createFaceModel(config));
    }

    private FaceAttributeModel createFaceModel(FaceAttributeConfig config) {
        Class<? extends FaceAttributeModel> clazz = registry.get((Object)config.getModelEnum());
        if (clazz == null) {
            throw new FaceException("Unsupported model");
        }
        FaceAttributeModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new FaceException(e);
        }
        model.loadModel(config);
        model.setFromFactory(true);
        return model;
    }

    public void closeAll() {
        modelMap.values().forEach(model -> {
            try {
                model.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        modelMap.clear();
    }

    public static void removeFromCache(FaceAttributeModelEnum modelEnum) {
        modelMap.remove((Object)modelEnum);
    }

    static {
        modelMap = new ConcurrentHashMap();
        registry = new ConcurrentHashMap<FaceAttributeModelEnum, Class<? extends FaceAttributeModel>>();
        FaceAttributeModelFactory.registerModel(FaceAttributeModelEnum.SEETA_FACE6_MODEL, Seetaface6FaceAttributeModel.class);
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

