/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.factory;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.face.config.FaceExpressionConfig;
import cn.smartjavaai.face.enums.ExpressionModelEnum;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.model.expression.CommonEmotionModel;
import cn.smartjavaai.face.model.expression.ExpressionModel;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionModelFactory {
    private static final Logger log = LoggerFactory.getLogger(ExpressionModelFactory.class);
    private static volatile ExpressionModelFactory instance;
    private static final ConcurrentHashMap<ExpressionModelEnum, ExpressionModel> modelMap;
    private static final Map<ExpressionModelEnum, Class<? extends ExpressionModel>> registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExpressionModelFactory getInstance() {
        if (instance != null) return instance;
        Class<ExpressionModelFactory> clazz = ExpressionModelFactory.class;
        synchronized (ExpressionModelFactory.class) {
            if (instance != null) return instance;
            instance = new ExpressionModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void registerModel(ExpressionModelEnum expressionModelEnum, Class<? extends ExpressionModel> clazz) {
        registry.put(expressionModelEnum, clazz);
    }

    public ExpressionModel getModel(FaceExpressionConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new FaceException("\u672a\u914d\u7f6e\u6d3b\u4f53\u68c0\u6d4b\u6a21\u578b");
        }
        return modelMap.computeIfAbsent(config.getModelEnum(), k -> this.createFaceModel(config));
    }

    private ExpressionModel createFaceModel(FaceExpressionConfig config) {
        Class<? extends ExpressionModel> clazz = registry.get((Object)config.getModelEnum());
        if (clazz == null) {
            throw new FaceException("Unsupported algorithm");
        }
        ExpressionModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new FaceException(e);
        }
        model.loadModel(config);
        model.setFromFactory(true);
        return model;
    }

    public void closeAll() {
        modelMap.values().forEach(model -> {
            try {
                model.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        modelMap.clear();
    }

    public static void removeFromCache(ExpressionModelEnum modelEnum) {
        modelMap.remove((Object)modelEnum);
    }

    static {
        modelMap = new ConcurrentHashMap();
        registry = new ConcurrentHashMap<ExpressionModelEnum, Class<? extends ExpressionModel>>();
        ExpressionModelFactory.registerModel(ExpressionModelEnum.DensNet121, CommonEmotionModel.class);
        ExpressionModelFactory.registerModel(ExpressionModelEnum.FrEmotion, CommonEmotionModel.class);
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

