/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.dao;

import cn.smartjavaai.face.sqllite.RowMapper;
import cn.smartjavaai.face.sqllite.SqliteHelper;
import cn.smartjavaai.face.utils.VectorUtils;
import cn.smartjavaai.face.vector.entity.FaceVector;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceDao {
    private static final Logger log = LoggerFactory.getLogger(FaceDao.class);
    private static final String FACE_TABLE_NAME = "face";
    private static final String SCHEMA_RESOURCE = "db/schema.sql";
    private static final ConcurrentHashMap<String, FaceDao> INSTANCES = new ConcurrentHashMap();
    private final String dbFilePath;

    public static FaceDao getInstance(String dbFilePath) {
        return INSTANCES.computeIfAbsent(dbFilePath, path -> new FaceDao((String)path));
    }

    private FaceDao(String dbFilePath) {
        this.dbFilePath = dbFilePath;
        try {
            SqliteHelper sqliteHelper = SqliteHelper.getInstance(dbFilePath);
            sqliteHelper.initializeDatabase(FACE_TABLE_NAME, SCHEMA_RESOURCE);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void insertOrUpdate(FaceVector faceVector) throws SQLException, ClassNotFoundException {
        SqliteHelper sqliteHelper = SqliteHelper.getInstance(this.dbFilePath);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", faceVector.getId());
        params.put("vector", VectorUtils.toByteArray(faceVector.getVector()));
        params.put("metadata", faceVector.getMetadata());
        sqliteHelper.executeInsertOrUpdate(FACE_TABLE_NAME, params);
    }

    public FaceVector findById(String id) throws SQLException, ClassNotFoundException {
        String sql;
        SqliteHelper sqliteHelper = SqliteHelper.getInstance(this.dbFilePath);
        List<FaceVector> faceVectors = sqliteHelper.executeQuery(sql = "select \"id\",\"vector\",\"metadata\" from face where \"id\" = '" + id + "'", new RowMapper<FaceVector>(){

            @Override
            public FaceVector mapRow(ResultSet rs, int id) throws SQLException {
                FaceVector face = new FaceVector();
                face.setId(rs.getString("id"));
                face.setVector(VectorUtils.toFloatArray(rs.getBytes("vector")));
                face.setMetadata(rs.getString("metadata"));
                return face;
            }
        });
        return CollectionUtils.isNotEmpty(faceVectors) ? faceVectors.get(0) : null;
    }

    public long deleteAll() throws SQLException, ClassNotFoundException {
        SqliteHelper sqliteHelper = SqliteHelper.getInstance(this.dbFilePath);
        long rows = sqliteHelper.executeUpdate("delete from face");
        return rows;
    }

    public List<FaceVector> findByIds(String ... ids) throws SQLException, ClassNotFoundException {
        String inKeys = Arrays.stream(ids).map(s -> "'" + s + "'").reduce((s1, s2) -> s1 + "," + s2).orElse("");
        String sql = "select \"id\",\"vector\",\"metadata\" from face where \"id\" in (" + inKeys + ")";
        log.debug("sql\uff1a{}", (Object)sql);
        SqliteHelper sqliteHelper = SqliteHelper.getInstance(this.dbFilePath);
        List<FaceVector> faceVectors = sqliteHelper.executeQuery(sql, new RowMapper<FaceVector>(){

            @Override
            public FaceVector mapRow(ResultSet rs, int id) throws SQLException {
                FaceVector face = new FaceVector();
                face.setId(rs.getString("id"));
                face.setVector(VectorUtils.toFloatArray(rs.getBytes("vector")));
                face.setMetadata(rs.getString("metadata"));
                return face;
            }
        });
        return faceVectors;
    }

    public boolean deleteFace(String ... ids) throws SQLException, ClassNotFoundException {
        String inKeys = Arrays.stream(ids).map(s -> "'" + s + "'").reduce((s1, s2) -> s1 + "," + s2).orElse("");
        SqliteHelper sqliteHelper = SqliteHelper.getInstance(this.dbFilePath);
        String sql = "delete from face where \"id\" in (" + inKeys + ")";
        int rows = sqliteHelper.executeUpdate(sql);
        log.debug("\u5220\u9664\u4e86{}\u884c\u6570\u636e", (Object)rows);
        return rows == ids.length;
    }

    public List<FaceVector> findFace(int pageNo, int pageSize) throws SQLException, ClassNotFoundException {
        long offset = (pageNo - 1) * pageSize;
        String sql = "select \"id\",\"vector\",\"metadata\" from face limit " + offset + "," + pageSize;
        SqliteHelper sqliteHelper = SqliteHelper.getInstance(this.dbFilePath);
        return sqliteHelper.executeQuery(sql, new RowMapper<FaceVector>(){

            @Override
            public FaceVector mapRow(ResultSet rs, int id) throws SQLException {
                FaceVector face = new FaceVector();
                face.setId(rs.getString("id"));
                face.setVector(VectorUtils.toFloatArray(rs.getBytes("vector")));
                face.setMetadata(rs.getString("metadata"));
                return face;
            }
        });
    }

    public static void closeAll() {
        INSTANCES.clear();
        log.debug("\u6240\u6709FaceDao\u5b9e\u4f8b\u5df2\u5173\u95ed");
    }
}

