/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.sakura.dao.util;

import cn.sliew.sakura.common.exception.Rethrower;
import cn.sliew.sakura.dao.meta.MetaHandler;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.MybatisXMLLanguageDriver;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.handlers.MybatisEnumTypeHandler;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.logging.slf4j.Slf4jImpl;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.scripting.LanguageDriverRegistry;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.defaults.DefaultSqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;

public enum MybatisUtil {

    private static SqlSessionFactory SQL_SESSION_FACTORY = null;

    public static HikariDataSource createDataSource(String driver, String jdbcUrl, String username, String password) {
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setDriverClassName(driver);
        dataSource.setJdbcUrl(jdbcUrl);
        dataSource.setUsername(username);
        dataSource.setPassword(password);
        dataSource.setMaximumPoolSize(20);
        dataSource.setConnectionTimeout(100000L);
        dataSource.setMinimumIdle(1);
        dataSource.setIdleTimeout(60000L);
        dataSource.setConnectionInitSql("SELECT 1 FROM DUAL");
        dataSource.setConnectionTestQuery("SELECT 1 FROM DUAL");
        return dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlSessionFactory getSqlSessionFactory(DataSource dataSource) {
        if (SQL_SESSION_FACTORY != null) {
            return SQL_SESSION_FACTORY;
        }
        Class<MybatisUtil> clazz = MybatisUtil.class;
        synchronized (MybatisUtil.class) {
            if (SQL_SESSION_FACTORY != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return SQL_SESSION_FACTORY;
            }
            SQL_SESSION_FACTORY = MybatisUtil.createSqlSessionFactory(dataSource);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return SQL_SESSION_FACTORY;
        }
    }

    private static SqlSessionFactory createSqlSessionFactory(DataSource dataSource) {
        try {
            MybatisConfiguration configuration = new MybatisConfiguration();
            LanguageDriverRegistry languageRegistry = configuration.getLanguageRegistry();
            languageRegistry.register(MybatisXMLLanguageDriver.class);
            languageRegistry.setDefaultDriverClass(MybatisXMLLanguageDriver.class);
            configuration.setDefaultEnumTypeHandler(MybatisEnumTypeHandler.class);
            configuration.setMapUnderscoreToCamelCase(true);
            configuration.setLogImpl(Slf4jImpl.class);
            Environment environment = new Environment("Sakura", (TransactionFactory)new JdbcTransactionFactory(), dataSource);
            configuration.setEnvironment(environment);
            configuration.setCacheEnabled(false);
            MybatisUtil.addMappers((Configuration)configuration, MybatisUtil.getMapperXmls());
            GlobalConfig globalConfig = GlobalConfigUtils.getGlobalConfig((Configuration)configuration);
            globalConfig.setMetaObjectHandler((MetaObjectHandler)new MetaHandler());
            return new DefaultSqlSessionFactory((Configuration)configuration);
        }
        catch (Exception e) {
            Rethrower.throwAs(e);
            return null;
        }
    }

    private static List<String> getMapperXmls() {
        return Arrays.asList("cn/sliew/sakura/dao/mapper/CatalogDatabaseMapper.xml", "cn/sliew/sakura/dao/mapper/CatalogFunctionMapper.xml", "cn/sliew/sakura/dao/mapper/CatalogTableMapper.xml");
    }

    private static void addMappers(Configuration configuration, List<String> xmls) throws IOException {
        for (String xml : xmls) {
            InputStream resource = Resources.getResourceAsStream((String)xml);
            XMLMapperBuilder builder = new XMLMapperBuilder(resource, configuration, xml, configuration.getSqlFragments());
            builder.parse();
        }
    }
}

