/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.sakura.catalog.service.convert;

import cn.sliew.sakura.catalog.service.convert.BaseConvert;
import cn.sliew.sakura.catalog.service.convert.Util;
import cn.sliew.sakura.catalog.service.dto.CatalogTableDTO;
import cn.sliew.sakura.catalog.service.dto.SchemaDTO;
import cn.sliew.sakura.common.exception.Rethrower;
import cn.sliew.sakura.common.util.CodecUtil;
import cn.sliew.sakura.common.util.JacksonUtil;
import cn.sliew.sakura.dao.entity.CatalogTable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.type.TypeReference;

public enum CatalogTableConvert implements BaseConvert<CatalogTable, CatalogTableDTO>
{
    INSTANCE;


    @Override
    public CatalogTable toDo(CatalogTableDTO dto) {
        try {
            CatalogTable entity = new CatalogTable();
            Util.copyProperties(dto, entity);
            entity.setKind(dto.getKind());
            entity.setName(dto.getName());
            if (dto.getSchema() != null) {
                entity.setSchema(JacksonUtil.toJsonString(dto.getSchema()));
            }
            entity.setOriginalQuery(dto.getOriginalQuery());
            entity.setExpandedQuery(dto.getExpandedQuery());
            entity.setRemark(dto.getRemark());
            if (dto.getProperties() != null) {
                entity.setProperties(CodecUtil.encrypt(JacksonUtil.toJsonString(dto.getProperties())));
            }
            return entity;
        }
        catch (Exception e) {
            Rethrower.throwAs(e);
            return null;
        }
    }

    @Override
    public CatalogTableDTO toDto(CatalogTable entity) {
        try {
            CatalogTableDTO dto = new CatalogTableDTO();
            Util.copyProperties(entity, dto);
            dto.setKind(entity.getKind());
            dto.setName(entity.getName());
            if (StringUtils.isNotBlank((CharSequence)entity.getSchema())) {
                dto.setSchema(JacksonUtil.parseJsonString(entity.getSchema(), SchemaDTO.class));
            }
            dto.setOriginalQuery(entity.getOriginalQuery());
            dto.setExpandedQuery(entity.getExpandedQuery());
            dto.setRemark(entity.getRemark());
            if (entity != null && StringUtils.isNotBlank((CharSequence)entity.getProperties())) {
                Map<String, String> properties = JacksonUtil.parseJsonString(CodecUtil.decrypt(entity.getProperties()), new TypeReference<Map<String, String>>(){});
                dto.setProperties(properties);
            }
            return dto;
        }
        catch (Exception e) {
            Rethrower.throwAs(e);
            return null;
        }
    }
}

