/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.sakura.catalog.service.convert;

import cn.sliew.sakura.catalog.service.convert.BaseConvert;
import cn.sliew.sakura.catalog.service.convert.Util;
import cn.sliew.sakura.catalog.service.dto.CatalogDatabaseDTO;
import cn.sliew.sakura.common.exception.Rethrower;
import cn.sliew.sakura.common.util.CodecUtil;
import cn.sliew.sakura.common.util.JacksonUtil;
import cn.sliew.sakura.dao.entity.CatalogDatabase;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.type.TypeReference;

public enum CatalogDatabaseConvert implements BaseConvert<CatalogDatabase, CatalogDatabaseDTO>
{
    INSTANCE;


    @Override
    public CatalogDatabase toDo(CatalogDatabaseDTO dto) {
        try {
            CatalogDatabase entity = new CatalogDatabase();
            Util.copyProperties(dto, entity);
            entity.setCatalog(dto.getCatalog());
            entity.setName(dto.getName());
            entity.setRemark(dto.getRemark());
            if (dto.getProperties() != null) {
                entity.setProperties(CodecUtil.encrypt(JacksonUtil.toJsonString(dto.getProperties())));
            }
            return entity;
        }
        catch (Exception e) {
            Rethrower.throwAs(e);
            return null;
        }
    }

    @Override
    public CatalogDatabaseDTO toDto(CatalogDatabase entity) {
        try {
            CatalogDatabaseDTO dto = new CatalogDatabaseDTO();
            Util.copyProperties(entity, dto);
            dto.setCatalog(entity.getCatalog());
            dto.setName(entity.getName());
            dto.setRemark(entity.getRemark());
            if (entity != null && StringUtils.isNotBlank((CharSequence)entity.getProperties())) {
                Map<String, String> properties = JacksonUtil.parseJsonString(CodecUtil.decrypt(entity.getProperties()), new TypeReference<Map<String, String>>(){});
                dto.setProperties(properties);
            }
            return dto;
        }
        catch (Exception e) {
            Rethrower.throwAs(e);
            return null;
        }
    }
}

