/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.sakura.catalog.factory;

import cn.sliew.sakura.catalog.service.dto.CatalogFunctionDTO;
import cn.sliew.sakura.common.dict.CatalogFunctionLanguage;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.FunctionLanguage;

public enum CatalogFunctionFactory {


    public static CatalogFunctionDTO fromFunction(String functionName, CatalogFunction function) {
        CatalogFunctionDTO catalogFunctionDTO = new CatalogFunctionDTO();
        catalogFunctionDTO.setName(functionName);
        catalogFunctionDTO.setClassName(function.getClassName());
        switch (function.getFunctionLanguage()) {
            case JAVA: {
                catalogFunctionDTO.setFunctionLanguage(CatalogFunctionLanguage.JAVA);
                break;
            }
            case SCALA: {
                catalogFunctionDTO.setFunctionLanguage(CatalogFunctionLanguage.JAVA);
                break;
            }
            case PYTHON: {
                catalogFunctionDTO.setFunctionLanguage(CatalogFunctionLanguage.JAVA);
                break;
            }
        }
        catalogFunctionDTO.setRemark(function.getDescription().orElse(""));
        return catalogFunctionDTO;
    }

    public static CatalogFunction toCatalogFunction(CatalogFunctionDTO catalogFunctionDTO) {
        String className = catalogFunctionDTO.getClassName();
        FunctionLanguage functionLanguage = null;
        switch (catalogFunctionDTO.getFunctionLanguage()) {
            case JAVA: {
                functionLanguage = FunctionLanguage.JAVA;
                break;
            }
            case SCALA: {
                functionLanguage = FunctionLanguage.SCALA;
                break;
            }
            case PYTHON: {
                functionLanguage = FunctionLanguage.PYTHON;
                break;
            }
        }
        return new CatalogFunctionImpl(className, functionLanguage);
    }
}

