/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.sakura.catalog;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;

public class SakuraCatalogTable
implements CatalogTable {
    private final CatalogBaseTable.TableKind kind;
    private final Schema schema;
    private final Map<String, String> options;
    private final String comment;

    public SakuraCatalogTable(CatalogBaseTable.TableKind kind, Schema schema, Map<String, String> options, String comment) {
        this.kind = kind;
        this.schema = schema;
        this.options = options;
        this.comment = comment;
    }

    public CatalogBaseTable.TableKind getTableKind() {
        return this.kind;
    }

    public Schema getUnresolvedSchema() {
        return this.schema;
    }

    public boolean isPartitioned() {
        return false;
    }

    public List<String> getPartitionKeys() {
        return Collections.emptyList();
    }

    public CatalogTable copy(Map<String, String> options) {
        return new SakuraCatalogTable(this.kind, this.schema, new HashMap<String, String>(options), this.comment);
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public String getComment() {
        return this.comment;
    }

    public CatalogBaseTable copy() {
        return new SakuraCatalogTable(this.kind, this.schema, new HashMap<String, String>(this.options), this.comment);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.comment);
    }

    public Optional<String> getDetailedDescription() {
        return Optional.empty();
    }
}

