/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.thread.rejected.policy;

import cn.sliew.milky.thread.RunnableWrapper;
import cn.sliew.milky.thread.SizeBlockingQueue;
import cn.sliew.milky.thread.XRejectedExecutionHandler;
import cn.sliew.milky.thread.rejected.policy.JVMUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AbortPolicyWithReport
extends ThreadPoolExecutor.AbortPolicy
implements XRejectedExecutionHandler {
    private static final Logger log = LogManager.getLogger(AbortPolicyWithReport.class);
    private final AtomicInteger rejected = new AtomicInteger();
    private final String name;
    private static volatile long lastPrintTime = 0L;
    private static final long TEN_MINUTES_MILLS = 600000L;
    private static final String OS_WIN_PREFIX = "win";
    private static final String OS_NAME_KEY = "os.name";
    private static final String WIN_DATETIME_FORMAT = "yyyy-MM-dd_HH-mm-ss";
    private static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd_HH:mm:ss";
    private static Semaphore guard = new Semaphore(1);

    public AbortPolicyWithReport(String name) {
        this.name = name;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        String msg = String.format("Thread pool is EXHAUSTED for %dth times! Thread Pool Name: %s, Pool Size: %d (active: %d, core: %d, max: %d, largest: %d), Task: %d (completed: %d), Executor status:(isShutdown:%s, isTerminated:%s, isTerminating:%s)", this.rejected.incrementAndGet(), this.name, e.getPoolSize(), e.getActiveCount(), e.getCorePoolSize(), e.getMaximumPoolSize(), e.getLargestPoolSize(), e.getTaskCount(), e.getCompletedTaskCount(), e.isShutdown(), e.isTerminated(), e.isTerminating());
        log.warn(msg);
        this.dumpJStack();
        if (r instanceof RunnableWrapper && ((RunnableWrapper)r).isForceExecution()) {
            BlockingQueue<Runnable> queue = e.getQueue();
            if (!(queue instanceof SizeBlockingQueue)) {
                throw new IllegalStateException("forced execution, but expected a size queue");
            }
            try {
                ((SizeBlockingQueue)queue).forcePut(r);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("forced execution, but got interrupted", ex);
            }
            return;
        }
        throw new RejectedExecutionException(msg);
    }

    private void dumpJStack() {
        long now = System.currentTimeMillis();
        if (now - lastPrintTime < 600000L) {
            return;
        }
        if (!guard.tryAcquire()) {
            return;
        }
        ExecutorService pool = Executors.newSingleThreadExecutor();
        pool.execute(() -> {
            String dumpPath = System.getProperty("user.home");
            String os = System.getProperty(OS_NAME_KEY).toLowerCase();
            DateTimeFormatter formatter = os.contains(OS_WIN_PREFIX) ? DateTimeFormatter.ofPattern(WIN_DATETIME_FORMAT) : DateTimeFormatter.ofPattern(DEFAULT_DATETIME_FORMAT);
            String dateStr = formatter.format(LocalDateTime.now());
            try (FileOutputStream jStackStream = new FileOutputStream(new File(dumpPath, "Milky_JStack.log." + dateStr));){
                JVMUtil.jstack(jStackStream);
            }
            catch (Throwable t) {
                log.error("dump jStack error", t);
            }
            finally {
                guard.release();
            }
            lastPrintTime = System.currentTimeMillis();
        });
        pool.shutdown();
    }

    @Override
    public long rejected() {
        return this.rejected.get();
    }
}

