/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.thread.context;

import cn.sliew.milky.thread.ThreadContext;
import cn.sliew.milky.thread.ThreadContextStack;
import cn.sliew.milky.thread.context.MutableThreadContextStack;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DefaultThreadContextStack
implements ThreadContextStack {
    private static final long serialVersionUID = -4937612028391653349L;
    private final ThreadLocal<MutableThreadContextStack> STACK = DefaultThreadContextStack.createThreadLocalStack();

    static ThreadLocal<MutableThreadContextStack> createThreadLocalStack() {
        return new InheritableThreadLocal<MutableThreadContextStack>(){

            @Override
            protected MutableThreadContextStack childValue(MutableThreadContextStack parentValue) {
                return parentValue != null ? new MutableThreadContextStack(parentValue.asList()) : new MutableThreadContextStack();
            }
        };
    }

    private MutableThreadContextStack getNonNullStackCopy() {
        MutableThreadContextStack values = this.STACK.get();
        return values == null ? new MutableThreadContextStack() : values.copy();
    }

    @Override
    public ThreadContext.StoredContext preserveContext() {
        MutableThreadContextStack threadContextStack = this.getNonNullStackCopy();
        this.STACK.set(new MutableThreadContextStack());
        return () -> this.STACK.set(threadContextStack);
    }

    @Override
    public ThreadContext.StoredContext storeContext() {
        MutableThreadContextStack threadContextStack = this.getNonNullStackCopy();
        return () -> this.STACK.set(threadContextStack);
    }

    @Override
    public boolean add(String s) {
        MutableThreadContextStack copy = this.getNonNullStackCopy();
        copy.add(s);
        copy.freeze();
        this.STACK.set(copy);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends String> strings) {
        if (strings.isEmpty()) {
            return false;
        }
        MutableThreadContextStack copy = this.getNonNullStackCopy();
        copy.addAll(strings);
        copy.freeze();
        this.STACK.set(copy);
        return true;
    }

    @Override
    public List<String> asList() {
        MutableThreadContextStack values = this.STACK.get();
        if (values == null) {
            return Collections.emptyList();
        }
        return values.asList();
    }

    @Override
    public void clear() {
        this.STACK.remove();
    }

    @Override
    public boolean contains(Object o) {
        MutableThreadContextStack values = this.STACK.get();
        return values != null && values.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        if (objects.isEmpty()) {
            return true;
        }
        MutableThreadContextStack values = this.STACK.get();
        return values != null && values.containsAll(objects);
    }

    @Override
    public ThreadContextStack copy() {
        MutableThreadContextStack values = this.STACK.get();
        if (values == null) {
            return new MutableThreadContextStack();
        }
        return values.copy();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThreadContextStack)) {
            return false;
        }
        ThreadContextStack other = (ThreadContextStack)obj;
        MutableThreadContextStack values = this.STACK.get();
        if (values == null) {
            return false;
        }
        return values.equals(other);
    }

    @Override
    public int getDepth() {
        MutableThreadContextStack values = this.STACK.get();
        return values == null ? 0 : values.getDepth();
    }

    @Override
    public int hashCode() {
        MutableThreadContextStack values = this.STACK.get();
        int prime = 31;
        int result = 1;
        result = 31 * result + (values == null ? 0 : values.hashCode());
        return result;
    }

    @Override
    public boolean isEmpty() {
        MutableThreadContextStack values = this.STACK.get();
        return values == null || values.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        MutableThreadContextStack values = this.STACK.get();
        if (values == null) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        return values.iterator();
    }

    @Override
    public String peek() {
        MutableThreadContextStack values = this.STACK.get();
        if (values == null || values.size() == 0) {
            return "";
        }
        return values.peek();
    }

    @Override
    public String pop() {
        MutableThreadContextStack values = this.STACK.get();
        if (values == null || values.size() == 0) {
            return "";
        }
        MutableThreadContextStack copy = (MutableThreadContextStack)values.copy();
        String result = copy.pop();
        copy.freeze();
        this.STACK.set(copy);
        return result;
    }

    @Override
    public void push(String message) {
        this.add(message);
    }

    @Override
    public boolean remove(Object o) {
        MutableThreadContextStack values = this.STACK.get();
        if (values == null || values.size() == 0) {
            return false;
        }
        MutableThreadContextStack copy = (MutableThreadContextStack)values.copy();
        boolean result = copy.remove(o);
        copy.freeze();
        this.STACK.set(copy);
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        if (objects.isEmpty()) {
            return false;
        }
        MutableThreadContextStack values = this.STACK.get();
        if (values == null || values.isEmpty()) {
            return false;
        }
        MutableThreadContextStack copy = (MutableThreadContextStack)values.copy();
        boolean result = copy.removeAll(objects);
        copy.freeze();
        this.STACK.set(copy);
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        if (objects.isEmpty()) {
            return false;
        }
        MutableThreadContextStack values = this.STACK.get();
        if (values == null || values.isEmpty()) {
            return false;
        }
        MutableThreadContextStack copy = (MutableThreadContextStack)values.copy();
        boolean result = copy.retainAll(objects);
        copy.freeze();
        this.STACK.set(copy);
        return result;
    }

    @Override
    public int size() {
        MutableThreadContextStack values = this.STACK.get();
        return values == null ? 0 : values.size();
    }

    @Override
    public Object[] toArray() {
        MutableThreadContextStack result = this.STACK.get();
        if (result == null) {
            return new String[0];
        }
        return result.toArray(new Object[result.size()]);
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        MutableThreadContextStack result = this.STACK.get();
        if (result == null) {
            if (ts.length > 0) {
                ts[0] = null;
            }
            return ts;
        }
        return result.toArray(ts);
    }

    public String toString() {
        MutableThreadContextStack values = this.STACK.get();
        return values == null ? "[]" : values.toString();
    }

    @Override
    public void trim(int depth) {
        if (depth < 0) {
            throw new IllegalArgumentException("Maximum stack depth cannot be negative");
        }
        MutableThreadContextStack values = this.STACK.get();
        if (values == null) {
            return;
        }
        MutableThreadContextStack copy = (MutableThreadContextStack)values.copy();
        copy.trim(depth);
        copy.freeze();
        this.STACK.set(copy);
    }

    @Override
    public ThreadContextStack getImmutableStackOrNull() {
        return this.STACK.get();
    }
}

