/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.thread;

import cn.sliew.milky.common.unit.TimeValue;
import cn.sliew.milky.common.unit.TimeValues;
import cn.sliew.milky.thread.DaemonThreadFactory;
import cn.sliew.milky.thread.ExecutorUtil;
import cn.sliew.milky.thread.MilkyThreadPoolExecutor;
import cn.sliew.milky.thread.TaskDecorator;
import cn.sliew.milky.thread.ThreadContext;
import cn.sliew.milky.thread.XRejectedExecutionHandler;
import cn.sliew.milky.thread.metrics.ThreadPoolExecutorMetrics;
import cn.sliew.milky.thread.rejected.policy.AbortPolicyWithReport;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

class ThreadPoolExecutorBuilder {
    private String name;
    private ThreadContext threadContext;
    private int coreSize = 1;
    private int maxSize = ExecutorUtil.availableProcessors();
    private TimeValue keepAlive = TimeValues.timeValueSeconds(60L);
    private BlockingQueue<Runnable> queue;
    private XRejectedExecutionHandler rejectedPolicy = new AbortPolicyWithReport("pool");
    private String threadNamePrefix;
    private int threadPriority = 5;
    private boolean daemon = false;
    private boolean waitForTasksToCompleteOnShutdown = false;
    private TimeValue awaitTermination = TimeValues.timeValueMillis(0L);
    private TaskDecorator taskDecorator;
    private MeterRegistry meterRegistry;

    public static ThreadPoolExecutorBuilder builder() {
        return new ThreadPoolExecutorBuilder();
    }

    private ThreadPoolExecutorBuilder() {
    }

    ThreadPoolExecutorBuilder name(String name) {
        this.name = name;
        return this;
    }

    ThreadPoolExecutorBuilder threadContext(ThreadContext threadContext) {
        this.threadContext = threadContext;
        return this;
    }

    ThreadPoolExecutorBuilder coreSize(int core) {
        this.coreSize = core;
        return this;
    }

    ThreadPoolExecutorBuilder maxSize(int max) {
        this.maxSize = max;
        return this;
    }

    ThreadPoolExecutorBuilder keepAliveTime(TimeValue aliveTime) {
        this.keepAlive = aliveTime;
        return this;
    }

    ThreadPoolExecutorBuilder blockingQueue(BlockingQueue<Runnable> queue) {
        this.queue = queue;
        return this;
    }

    ThreadPoolExecutorBuilder threadNamePrefix(String prefix) {
        this.threadNamePrefix = String.format("milky[%s]", prefix);
        return this;
    }

    ThreadPoolExecutorBuilder threadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
        return this;
    }

    ThreadPoolExecutorBuilder daemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    ThreadPoolExecutorBuilder rejectedPolicy(XRejectedExecutionHandler rejectedPolicy) {
        this.rejectedPolicy = rejectedPolicy;
        return this;
    }

    ThreadPoolExecutorBuilder waitForTasksToCompleteOnShutdown(boolean wait) {
        this.waitForTasksToCompleteOnShutdown = wait;
        return this;
    }

    ThreadPoolExecutorBuilder awaitTerminationTime(TimeValue waitTime) {
        this.awaitTermination = waitTime;
        return this;
    }

    ThreadPoolExecutorBuilder taskDecorator(TaskDecorator decorator) {
        this.taskDecorator = this.taskDecorator;
        return this;
    }

    ThreadPoolExecutorBuilder meterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        return this;
    }

    MilkyThreadPoolExecutor build() {
        ThreadFactory threadFactory = this.buildThreadFacotry();
        MilkyThreadPoolExecutor executor = new MilkyThreadPoolExecutor(this.name, this.threadContext, this.coreSize, this.maxSize, this.keepAlive.millis(), TimeUnit.MILLISECONDS, this.queue, threadFactory, this.rejectedPolicy);
        executor.setWaitForTasksToCompleteOnShutdown(this.waitForTasksToCompleteOnShutdown);
        executor.setAwaitTerminationMillis(this.awaitTermination.millis());
        if (this.meterRegistry != null) {
            new ThreadPoolExecutorMetrics(executor, new Tag[0]).bindTo(this.meterRegistry);
        }
        return executor;
    }

    private ThreadFactory buildThreadFacotry() {
        return new DaemonThreadFactory(this.threadNamePrefix, this.threadPriority, this.daemon);
    }
}

