/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.thread;

import cn.sliew.milky.thread.ExecutorUtil;
import cn.sliew.milky.thread.MilkyThreadPoolExecutor;
import cn.sliew.milky.thread.ThreadPoolExecutorBuilder;
import cn.sliew.milky.thread.ThreadPoolType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum ThreadPoolConfigEnum {
    SAME("same", ThreadPoolType.DIRECT){
        private MilkyThreadPoolExecutor executor;

        @Override
        public MilkyThreadPoolExecutor getInstance() {
            if (this.executor == null) {
                this.executor = ThreadPoolExecutorBuilder.builder().name(this.getName()).coreSize(ExecutorUtil.availableProcessors()).maxSize(ExecutorUtil.twiceProcessors()).build();
            }
            return this.executor;
        }
    };

    private String name;
    private ThreadPoolType type;
    private static final Map<String, ThreadPoolConfigEnum> TYPE_MAP;

    private ThreadPoolConfigEnum(String name, ThreadPoolType type) {
        this.name = name;
        this.type = type;
    }

    public static ThreadPoolConfigEnum ofName(String name) {
        ThreadPoolConfigEnum threadPoolConfigEnum = TYPE_MAP.get(name);
        if (threadPoolConfigEnum == null) {
            throw new IllegalArgumentException(String.format("no ThreadPoolConfigEnum for %s", name));
        }
        return threadPoolConfigEnum;
    }

    public abstract MilkyThreadPoolExecutor getInstance();

    public String getName() {
        return this.name;
    }

    public ThreadPoolType getType() {
        return this.type;
    }

    static {
        HashMap<String, ThreadPoolConfigEnum> typeMap = new HashMap<String, ThreadPoolConfigEnum>();
        for (ThreadPoolConfigEnum threadPoolConfigEnum : ThreadPoolConfigEnum.values()) {
            typeMap.put(threadPoolConfigEnum.name, threadPoolConfigEnum);
        }
        TYPE_MAP = Collections.unmodifiableMap(typeMap);
    }
}

