/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.thread;

import cn.sliew.milky.thread.ThreadContextMap;
import cn.sliew.milky.thread.ThreadContextStack;
import cn.sliew.milky.thread.context.DefaultThreadContextMap;
import cn.sliew.milky.thread.context.DefaultThreadContextStack;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;

public final class ThreadContext {
    public static final ThreadContextStack EMPTY_STACK = new ThreadContextStack.EmptyThreadContextStack();
    private static ThreadContextMap contextMap = new DefaultThreadContextMap();
    private static ThreadContextStack contextStack = new DefaultThreadContextStack();

    private ThreadContext() {
    }

    public StoredContext preserveContext() {
        StoredContext storedContextMap = contextMap.preserveContext();
        StoredContext storedContextStack = contextStack.preserveContext();
        return () -> {
            storedContextMap.restore();
            storedContextStack.restore();
        };
    }

    public StoredContext storeContext() {
        StoredContext storedContextMap = contextMap.storeContext();
        StoredContext storedContextStack = contextStack.storeContext();
        return () -> {
            storedContextMap.restore();
            storedContextStack.restore();
        };
    }

    public Supplier<StoredContext> newRestorableContext() {
        return this.wrapRestorable(this.storeContext());
    }

    public Supplier<StoredContext> wrapRestorable(StoredContext storedContext) {
        return () -> {
            StoredContext context = this.storeContext();
            storedContext.restore();
            return context;
        };
    }

    public static void put(String key, String value) {
        contextMap.put(key, value);
    }

    public static void putIfAbsent(String key, String value) {
        if (!contextMap.containsKey(key)) {
            contextMap.put(key, value);
        }
    }

    public static void putAll(Map<String, String> m) {
        for (Map.Entry<String, String> entry : m.entrySet()) {
            contextMap.put(entry.getKey(), entry.getValue());
        }
    }

    public static String get(String key) {
        return contextMap.get(key);
    }

    public static void remove(String key) {
        contextMap.remove(key);
    }

    public static void removeAll(Iterable<String> keys) {
        for (String key : keys) {
            contextMap.remove(key);
        }
    }

    public static void clearMap() {
        contextMap.clear();
    }

    public static void clearAll() {
        ThreadContext.clearMap();
        ThreadContext.clearStack();
    }

    public static boolean containsKey(String key) {
        return contextMap.containsKey(key);
    }

    public static Map<String, String> getContext() {
        return contextMap.getCopy();
    }

    public static Map<String, String> getImmutableContext() {
        Map<String, String> map = contextMap.getImmutableMapOrNull();
        return map == null ? Collections.emptyMap() : map;
    }

    public static ThreadContextMap getThreadContextMap() {
        return contextMap;
    }

    public static boolean isEmpty() {
        return contextMap.isEmpty();
    }

    public static void clearStack() {
        contextStack.clear();
    }

    public static ThreadContextStack cloneStack() {
        return contextStack.copy();
    }

    public static ThreadContextStack getImmutableStack() {
        ThreadContextStack result = contextStack.getImmutableStackOrNull();
        return result == null ? EMPTY_STACK : result;
    }

    public static void setStack(Collection<String> stack) {
        if (stack.isEmpty()) {
            return;
        }
        contextStack.clear();
        contextStack.addAll(stack);
    }

    public static int getDepth() {
        return contextStack.getDepth();
    }

    public static String pop() {
        return contextStack.pop();
    }

    public static String peek() {
        return contextStack.peek();
    }

    public static void push(String message) {
        contextStack.push(message);
    }

    public static void removeStack() {
        contextStack.clear();
    }

    public static void trim(int depth) {
        contextStack.trim(depth);
    }

    @FunctionalInterface
    public static interface StoredContext
    extends AutoCloseable {
        default public void restore() {
            this.close();
        }

        @Override
        public void close();
    }
}

