/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.thread;

import cn.sliew.milky.common.collect.ConcurrentReferenceHashMap;
import cn.sliew.milky.thread.DaemonThreadFactory;
import cn.sliew.milky.thread.RunnableWrapper;
import cn.sliew.milky.thread.TaskDecorator;
import cn.sliew.milky.thread.ThreadContext;
import cn.sliew.milky.thread.XRejectedExecutionHandler;
import cn.sliew.milky.thread.rejected.policy.AbortPolicyWithReport;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MilkyThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger log = LogManager.getLogger(MilkyThreadPoolExecutor.class);
    private final String name;
    private final ThreadContext threadContext;
    private volatile ShutdownListener listener;
    private final Object monitor = new Object();
    private RejectedExecutionHandler rejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();
    private ThreadFactory threadFactory;
    private boolean waitForTasksToCompleteOnShutdown = false;
    private long awaitTerminationMillis = 0L;
    private TaskDecorator taskDecorator;
    private final Map<Runnable, Object> decoratedTaskMap = new ConcurrentReferenceHashMap<Runnable, Object>(16, ConcurrentReferenceHashMap.ReferenceType.WEAK);

    public final String getName() {
        return this.name;
    }

    public void setWaitForTasksToCompleteOnShutdown(boolean waitForJobsToCompleteOnShutdown) {
        this.waitForTasksToCompleteOnShutdown = waitForJobsToCompleteOnShutdown;
    }

    public void setAwaitTerminationMillis(long awaitTerminationMillis) {
        this.awaitTerminationMillis = awaitTerminationMillis;
    }

    public MilkyThreadPoolExecutor(String name, ThreadContext threadContext, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        this(name, threadContext, corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new DaemonThreadFactory(name + "-pool"), new AbortPolicyWithReport(name));
    }

    public MilkyThreadPoolExecutor(String name, ThreadContext threadContext, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        this(name, threadContext, corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, new AbortPolicyWithReport(name));
    }

    public MilkyThreadPoolExecutor(String name, ThreadContext threadContext, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, XRejectedExecutionHandler handler) {
        this(name, threadContext, corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new DaemonThreadFactory(name + "-pool"), handler);
    }

    public MilkyThreadPoolExecutor(String name, ThreadContext threadContext, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, XRejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.name = name;
        this.threadContext = threadContext;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
    }

    @Override
    public void execute(Runnable command) {
        try {
            if (this.taskDecorator != null) {
                Runnable decorated = this.taskDecorator.decorate(command);
                if (decorated != command) {
                    this.decoratedTaskMap.put(decorated, command);
                }
                super.execute(decorated);
            } else {
                super.execute(command);
            }
        }
        catch (RejectedExecutionException ex) {
            if (command instanceof RunnableWrapper) {
                try {
                    ((RunnableWrapper)command).onRejection(ex);
                }
                finally {
                    ((RunnableWrapper)command).onAfter();
                }
            }
            throw ex;
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void terminated() {
        super.terminated();
        Object object = this.monitor;
        synchronized (object) {
            if (this.listener != null) {
                try {
                    this.listener.onTerminated();
                }
                finally {
                    this.listener = null;
                }
            }
        }
    }

    @Override
    public final String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName()).append('[');
        b.append("name = ").append(this.name).append(", ");
        this.appendThreadPoolExecutorDetails(b);
        b.append(super.toString()).append(']');
        return b.toString();
    }

    protected void appendThreadPoolExecutorDetails(StringBuilder sb) {
    }

    @Override
    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info(String.format("Shutting down ExecutorService %s", this.name));
        }
        if (this.waitForTasksToCompleteOnShutdown) {
            super.shutdown();
        } else {
            for (Runnable remainingTask : super.shutdownNow()) {
                this.cancelRemainingTask(remainingTask);
            }
        }
        this.awaitTerminationIfNecessary();
    }

    protected void cancelRemainingTask(Runnable task) {
        Object original;
        if (task instanceof Future) {
            ((Future)((Object)task)).cancel(true);
        }
        if ((original = this.decoratedTaskMap.get(task)) instanceof Future) {
            ((Future)original).cancel(true);
        }
    }

    private void awaitTerminationIfNecessary() {
        if (this.awaitTerminationMillis > 0L) {
            try {
                if (!this.awaitTermination(this.awaitTerminationMillis, TimeUnit.MILLISECONDS) && log.isWarnEnabled()) {
                    log.warn(String.format("Timed out while waiting for executor %s to terminate", this.name));
                }
            }
            catch (InterruptedException ex) {
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Interrupted while waiting for executor %s to terminate", this.name));
                }
                Thread.currentThread().interrupt();
            }
        }
    }

    public static interface ShutdownListener {
        public void onTerminated();
    }
}

