/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.recycler;

import cn.sliew.milky.common.recycler.AbstractRecycler;
import cn.sliew.milky.common.recycler.Source;
import cn.sliew.milky.common.recycler.Value;

public class NoneRecycler<T>
extends AbstractRecycler<T> {
    public NoneRecycler(Source<T> source) {
        super(source);
    }

    @Override
    public Value<T> obtain() {
        return new NoneValue(this.source.newInstance());
    }

    public static class NoneValue<T>
    implements Value<T> {
        T value;

        NoneValue(T value) {
            this.value = value;
        }

        @Override
        public T value() {
            return this.value;
        }

        @Override
        public boolean isRecycled() {
            return false;
        }

        @Override
        public void close() {
            if (this.value == null) {
                throw new IllegalStateException("recycler entry already released...");
            }
            this.value = null;
        }
    }
}

