/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.thread.context;

import cn.sliew.milky.thread.ThreadContext;
import cn.sliew.milky.thread.ThreadContextMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultThreadContextMap
implements ThreadContextMap {
    private final ThreadLocal<Map<String, String>> localMap = DefaultThreadContextMap.createThreadLocalMap();

    static ThreadLocal<Map<String, String>> createThreadLocalMap() {
        return new InheritableThreadLocal<Map<String, String>>(){

            @Override
            protected Map<String, String> childValue(Map<String, String> parentValue) {
                return parentValue != null ? Collections.unmodifiableMap(new HashMap<String, String>(parentValue)) : null;
            }
        };
    }

    @Override
    public ThreadContext.StoredContext preserveContext() {
        Map<String, String> mapOrNull = this.getImmutableMapOrNull();
        this.localMap.set(new HashMap());
        return () -> this.localMap.set(mapOrNull);
    }

    @Override
    public ThreadContext.StoredContext storeContext() {
        Map<String, String> mapOrNull = this.getImmutableMapOrNull();
        return () -> this.localMap.set(mapOrNull);
    }

    @Override
    public void put(String key, String value) {
        Map<String, String> map = this.localMap.get();
        map = map == null ? new HashMap<String, String>() : new HashMap<String, String>(map);
        map.put(key, value);
        this.localMap.set(Collections.unmodifiableMap(map));
    }

    @Override
    public String get(String key) {
        Map<String, String> map = this.localMap.get();
        return map == null ? null : map.get(key);
    }

    @Override
    public void remove(String key) {
        Map<String, String> map = this.localMap.get();
        if (map != null) {
            HashMap<String, String> copy = new HashMap<String, String>(map);
            copy.remove(key);
            this.localMap.set(Collections.unmodifiableMap(copy));
        }
    }

    @Override
    public void clear() {
        this.localMap.remove();
    }

    @Override
    public boolean containsKey(String key) {
        Map<String, String> map = this.localMap.get();
        return map != null && map.containsKey(key);
    }

    @Override
    public Map<String, String> getCopy() {
        Map<String, String> map = this.localMap.get();
        return map == null ? new HashMap<String, String>() : new HashMap<String, String>(map);
    }

    @Override
    public Map<String, String> getImmutableMapOrNull() {
        return this.localMap.get();
    }

    @Override
    public boolean isEmpty() {
        Map<String, String> map = this.localMap.get();
        return map == null || map.size() == 0;
    }

    public String toString() {
        Map<String, String> map = this.localMap.get();
        return map == null ? "{}" : map.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        Map<String, String> map = this.localMap.get();
        result = 31 * result + (map == null ? 0 : map.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThreadContextMap)) {
            return false;
        }
        ThreadContextMap other = (ThreadContextMap)obj;
        Map<String, String> map = this.localMap.get();
        Map<String, String> otherMap = other.getImmutableMapOrNull();
        return !(map == null ? otherMap != null : !map.equals(otherMap));
    }
}

