/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.thread;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum ThreadPoolType {
    DIRECT("direct"),
    FIXED("fixed"),
    SCALING("scaling");

    private final String type;
    private static final Map<String, ThreadPoolType> TYPE_MAP;

    private ThreadPoolType(String type) {
        this.type = type;
    }

    public static ThreadPoolType ofType(String type) {
        ThreadPoolType threadPoolType = TYPE_MAP.get(type);
        if (threadPoolType == null) {
            throw new IllegalArgumentException(String.format("no ThreadPoolType for %s", type));
        }
        return threadPoolType;
    }

    public String getType() {
        return this.type;
    }

    static {
        HashMap<String, ThreadPoolType> typeMap = new HashMap<String, ThreadPoolType>();
        for (ThreadPoolType threadPoolType : ThreadPoolType.values()) {
            typeMap.put(threadPoolType.getType(), threadPoolType);
        }
        TYPE_MAP = Collections.unmodifiableMap(typeMap);
    }
}

