/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.thread;

import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.thread.SizeBlockingQueue;
import java.util.concurrent.BlockingQueue;

final class ResizableBlockingQueue<E>
extends SizeBlockingQueue<E> {
    private volatile int capacity;

    ResizableBlockingQueue(BlockingQueue<E> queue, int initialCapacity) {
        super(queue, initialCapacity);
        this.capacity = initialCapacity;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int remainingCapacity() {
        return Math.max(0, this.capacity());
    }

    public synchronized int adjustCapacity(int optimalCapacity, int adjustmentAmount, int minCapacity, int maxCapacity) {
        Ensures.checkArgument(adjustmentAmount > 0, () -> "adjustment amount should be a positive value");
        Ensures.checkArgument(optimalCapacity > 0, () -> "desired capacity cannot be negative");
        Ensures.checkArgument(minCapacity >= 0, () -> "cannot have min capacity smaller than 0");
        Ensures.checkArgument(maxCapacity >= minCapacity, () -> "cannot have max capacity smaller than min capacity");
        if (optimalCapacity == this.capacity) {
            return this.capacity;
        }
        if (optimalCapacity > this.capacity + adjustmentAmount) {
            int newCapacity;
            this.capacity = newCapacity = Math.min(maxCapacity, this.capacity + adjustmentAmount);
            return newCapacity;
        }
        if (optimalCapacity < this.capacity - adjustmentAmount) {
            int newCapacity;
            this.capacity = newCapacity = Math.max(minCapacity, this.capacity - adjustmentAmount);
            return newCapacity;
        }
        return this.capacity;
    }
}

