/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.thread;

import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.thread.ResizableBlockingQueue;
import cn.sliew.milky.thread.ThreadEagerQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;

class ExecutorUtil {
    private static int processors = Runtime.getRuntime().availableProcessors();

    private ExecutorUtil() {
        throw new UnsupportedOperationException("no instance");
    }

    static int bounded(int value, int min, int max) {
        return Math.min(max, Math.max(min, value));
    }

    static int boundedByUpper(int value, int max) {
        return ExecutorUtil.bounded(value, 1, max);
    }

    static int boundedBylower(int value, int min) {
        return ExecutorUtil.bounded(value, min, Integer.MAX_VALUE);
    }

    static int halfProcessors() {
        return (processors + 1) / 2;
    }

    static int availableProcessors() {
        return processors;
    }

    static int oneAndhalfProcessors() {
        return processors * 3 / 2 + 1;
    }

    static int twiceProcessors() {
        return processors * 2;
    }

    static BlockingQueue<Runnable> boundedQueue(int queueCapacity) {
        Ensures.checkArgument(queueCapacity > 0, () -> "queueCapacity must greater than 0");
        return new LinkedBlockingQueue<Runnable>(queueCapacity);
    }

    static BlockingQueue<Runnable> unboundedQueue() {
        return new LinkedTransferQueue<Runnable>();
    }

    static BlockingQueue<Runnable> zeroQueue() {
        return new SynchronousQueue<Runnable>();
    }

    static BlockingQueue<Runnable> eagerQueue(ThreadPoolExecutor executor) {
        return new ThreadEagerQueue<Runnable>(executor);
    }

    static BlockingQueue<Runnable> resizableQueue(BlockingQueue<Runnable> queue, int initialCapacity) {
        return new ResizableBlockingQueue<Runnable>(queue, initialCapacity);
    }
}

