/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.thread;

import cn.sliew.milky.common.check.Ensures;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class DaemonThreadFactory
implements ThreadFactory {
    private final String threadNamePrefix;
    private final int threadPriority;
    private final boolean daemon;
    private final ThreadGroup threadGroup;
    private final AtomicInteger threadCount = new AtomicInteger(0);

    public DaemonThreadFactory() {
        this(null);
    }

    DaemonThreadFactory(String threadNamePrefix) {
        this(threadNamePrefix, true);
    }

    public DaemonThreadFactory(String threadNamePrefix, int threadPriority) {
        this(threadNamePrefix, threadPriority, true);
    }

    DaemonThreadFactory(String threadNamePrefix, boolean daemon) {
        this(threadNamePrefix, 5, daemon);
    }

    public DaemonThreadFactory(String threadNamePrefix, int threadPriority, boolean daemon) {
        this(threadNamePrefix, threadPriority, daemon, System.getSecurityManager() != null ? System.getSecurityManager().getThreadGroup() : Thread.currentThread().getThreadGroup());
    }

    public DaemonThreadFactory(String threadNamePrefix, int threadPriority, boolean daemon, ThreadGroup threadGroup) {
        this.threadNamePrefix = threadNamePrefix == null || threadNamePrefix.isEmpty() ? this.getDefaultThreadNamePrefix() : threadNamePrefix;
        this.threadPriority = threadPriority;
        this.daemon = daemon;
        this.threadGroup = Ensures.checkNotNull(threadGroup, () -> "threadGroup null");
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this.threadGroup, runnable, this.nextThreadName());
        thread.setPriority(this.threadPriority);
        thread.setDaemon(this.daemon);
        return thread;
    }

    protected String nextThreadName() {
        return String.format("[%sT#%d]", this.threadNamePrefix, this.threadCount.incrementAndGet());
    }

    protected String getDefaultThreadNamePrefix() {
        return this.getClass().getSimpleName();
    }
}

