/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.serialize.kryo;

import cn.sliew.milky.serialize.DataOutputView;
import cn.sliew.milky.serialize.kryo.utils.KryoUtils;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.OutputStream;

public class KryoDataOutputView
implements DataOutputView {
    private final Kryo kryo = KryoUtils.get();
    private final Output output;

    public KryoDataOutputView(OutputStream outputStream) {
        this.output = new Output(outputStream);
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.output.write(b);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.output.write(b);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.output.write(b, off, len);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        try {
            this.output.writeBoolean(v);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeByte(int v) throws IOException {
        try {
            this.output.writeByte(v);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeShort(int v) throws IOException {
        try {
            this.output.writeShort(v);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeChar(int v) throws IOException {
        try {
            this.output.writeChar((char)v);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeInt(int v) throws IOException {
        try {
            this.output.writeInt(v);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        try {
            this.output.writeLong(v);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        try {
            this.output.writeFloat(v);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        try {
            this.output.writeDouble(v);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeBytes(String s) throws IOException {
        try {
            this.output.writeString(s);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        try {
            this.output.writeString(s);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        try {
            this.output.writeString(s);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        try {
            this.kryo.writeClassAndObject(this.output, obj);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void flushBuffer() throws IOException {
        try {
            this.output.flush();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }
}

