/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.serialize.kryo;

import cn.sliew.milky.serialize.DataInputView;
import cn.sliew.milky.serialize.kryo.utils.KryoUtils;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import java.io.IOException;
import java.io.InputStream;

public class KryoDataInputView
implements DataInputView {
    private final Kryo kryo = KryoUtils.get();
    private final Input input;

    public KryoDataInputView(InputStream inputStream) {
        this.input = new Input(inputStream);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        try {
            this.input.read(b);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        try {
            this.input.read(b, off, len);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        try {
            return (int)this.input.skip(Integer.valueOf(n).longValue());
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        try {
            return this.input.readBoolean();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte readByte() throws IOException {
        try {
            return this.input.readByte();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int readUnsignedByte() throws IOException {
        try {
            return this.input.readByteUnsigned();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public short readShort() throws IOException {
        try {
            return this.input.readShort();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int readUnsignedShort() throws IOException {
        try {
            return this.input.readShortUnsigned();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public char readChar() throws IOException {
        try {
            return this.input.readChar();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            return this.input.readInt();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            return this.input.readLong();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public float readFloat() throws IOException {
        try {
            return this.input.readFloat();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public double readDouble() throws IOException {
        try {
            return this.input.readDouble();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String readLine() throws IOException {
        try {
            return this.input.readString();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String readUTF() throws IOException {
        try {
            return this.input.readString();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        try {
            return this.kryo.readClassAndObject(this.input);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }
}

