/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.parse;

import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.common.parse.Token;
import cn.sliew.milky.common.parse.TokenParseException;
import cn.sliew.milky.common.util.ToStringBuilder;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TokenFormat
implements Serializable {
    private static final long serialVersionUID = 2480921128990881242L;
    private static final TokenFormat DEFAULT_FORMAT = new TokenFormat('[', ':', ']', '/');
    private final char openSegment;
    private final char closeSegment;
    private final char segmentDelimiter;
    private final char typeValueSeparator;
    private final Pattern segmentPattern;
    private final Map<Character, String> encodedCharacterMap = new HashMap<Character, String>();

    static TokenFormat getDefault() {
        return DEFAULT_FORMAT;
    }

    private static String quote(char c) {
        return Pattern.quote(String.valueOf(c));
    }

    private static String encode(char c) {
        try {
            return URLEncoder.encode(String.valueOf(c), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("UTF-8 should be supported", e);
        }
    }

    public TokenFormat(char openSegment, char typeValueSeparator, char closeSegment, char segmentDelimiter) {
        this.openSegment = openSegment;
        this.typeValueSeparator = typeValueSeparator;
        this.closeSegment = closeSegment;
        this.segmentDelimiter = segmentDelimiter;
        this.segmentPattern = Pattern.compile(String.format("%s(.+)%s(.+)%s", TokenFormat.quote(openSegment), TokenFormat.quote(typeValueSeparator), TokenFormat.quote(closeSegment)), 32);
        this.encodedCharacterMap.computeIfAbsent(Character.valueOf('%'), TokenFormat::encode);
        this.encodedCharacterMap.computeIfAbsent(Character.valueOf('+'), TokenFormat::encode);
        this.encodedCharacterMap.computeIfAbsent(Character.valueOf(openSegment), TokenFormat::encode);
        this.encodedCharacterMap.computeIfAbsent(Character.valueOf(typeValueSeparator), TokenFormat::encode);
        this.encodedCharacterMap.computeIfAbsent(Character.valueOf(closeSegment), TokenFormat::encode);
        this.encodedCharacterMap.computeIfAbsent(Character.valueOf(segmentDelimiter), TokenFormat::encode);
    }

    Token parse(String source) throws TokenParseException {
        String[] parts = source.split(String.valueOf(this.segmentDelimiter));
        List<Segment> segments = Arrays.stream(parts).map(this::createSegment).collect(Collectors.toList());
        return new Token(this, segments);
    }

    private Segment createSegment(String segmentString) throws TokenParseException {
        Matcher segmentMatcher = this.segmentPattern.matcher(segmentString);
        if (!segmentMatcher.matches()) {
            throw new TokenParseException(String.format("'%s' is not a well-formed Token segment", segmentString));
        }
        String type = TokenFormat.decode(this.checkAllowed(segmentMatcher.group(1)));
        String value = TokenFormat.decode(this.checkAllowed(segmentMatcher.group(2)));
        return new Segment(type, value);
    }

    private String checkAllowed(String typeOrValue) {
        this.checkDoesNotContain(typeOrValue, this.segmentDelimiter);
        this.checkDoesNotContain(typeOrValue, this.typeValueSeparator);
        this.checkDoesNotContain(typeOrValue, this.openSegment);
        this.checkDoesNotContain(typeOrValue, this.closeSegment);
        return typeOrValue;
    }

    private void checkDoesNotContain(String typeOrValue, char forbiddenCharacter) {
        Ensures.condition(typeOrValue.indexOf(forbiddenCharacter) < 0, () -> String.format("type or value '%s' must not contain '%s'", typeOrValue, Character.valueOf(forbiddenCharacter)));
    }

    String format(Token token) {
        return token.getSegments().stream().map(this::describe).collect(Collectors.joining(String.valueOf(this.segmentDelimiter)));
    }

    private String describe(Segment segment) {
        String body = this.encode(segment.getType()) + this.typeValueSeparator + this.encode(segment.getValue());
        return this.openSegment + body + this.closeSegment;
    }

    private String encode(String s) {
        StringBuilder builder = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            String value = this.encodedCharacterMap.get(Character.valueOf(c));
            if (value == null) {
                builder.append(c);
                continue;
            }
            builder.append(value);
        }
        return builder.toString();
    }

    private static String decode(String s) {
        try {
            return URLDecoder.decode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new TokenParseException("UTF-8 should be supported", e);
        }
    }

    public static class Segment
    implements Serializable {
        private static final long serialVersionUID = 4187949052186059932L;
        private final String type;
        private final String value;

        Segment(String type, String value) {
            Ensures.notBlank(type, () -> "type must not be null or blank");
            Ensures.notBlank(value, () -> "value must not be null or blank");
            this.type = type;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Segment that = (Segment)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value);
        }

        public String toString() {
            return new ToStringBuilder(this).append("type", this.type).append("value", this.value).toString();
        }
    }
}

