/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.lifecycle;

import cn.sliew.milky.common.lifecycle.LifeCycle;
import cn.sliew.milky.common.lifecycle.LifeCycleListener;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractLifeCycle
implements LifeCycle {
    private final Semaphore guard = new Semaphore(1);
    private final DelegatingLifeCycleListener lifeCycleListener = new DelegatingLifeCycleListener();
    private AtomicReference<LifeCycle.State> stateHolder = new AtomicReference();

    @Override
    public LifeCycle.State getState() {
        return this.stateHolder.get();
    }

    @Override
    public void addLifeCycleListener(LifeCycleListener listener) {
        this.lifeCycleListener.listeners.add(listener);
    }

    @Override
    public void removeLifeCycleListener(LifeCycleListener listener) {
        this.lifeCycleListener.listeners.remove(listener);
    }

    @Override
    public LifeCycle.LifeCycleResult initialize() {
        if (!this.guard.tryAcquire()) {
            return LifeCycle.LifeCycleResult.failure(new IllegalStateException("acquire lifecycle guard failed!"));
        }
        try {
            if (this.stateHolder.compareAndSet(null, LifeCycle.State.INITIALIZING)) {
                this.lifeCycleListener.beforeInitialize(this);
                this.doInitialize();
                this.lifeCycleListener.afterInitialize(this);
                this.stateHolder.compareAndSet(LifeCycle.State.INITIALIZING, LifeCycle.State.INITIALIZED);
                LifeCycle.LifeCycleResult lifeCycleResult = LifeCycle.LifeCycleResult.success();
                return lifeCycleResult;
            }
            String message = String.format("wrong state '%s' which can't be initialized", new Object[]{this.getState()});
            LifeCycle.LifeCycleResult lifeCycleResult = LifeCycle.LifeCycleResult.failure(new IllegalStateException(message));
            return lifeCycleResult;
        }
        catch (Throwable throwable) {
            this.stateHolder.compareAndSet(LifeCycle.State.INITIALIZING, null);
            LifeCycle.LifeCycleResult lifeCycleResult = LifeCycle.LifeCycleResult.failure(throwable);
            return lifeCycleResult;
        }
        finally {
            this.guard.release();
        }
    }

    @Override
    public LifeCycle.LifeCycleSupportResult supportInitialize() {
        if (this.getState() == null) {
            return LifeCycle.LifeCycleSupportResult.support("never initialized");
        }
        return LifeCycle.LifeCycleSupportResult.unsupport(String.format("ever initialized, current state: '%s'", new Object[]{this.getState()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LifeCycle.LifeCycleResult start() {
        if (!this.guard.tryAcquire()) {
            return LifeCycle.LifeCycleResult.failure(new IllegalStateException("acquire lifecycle guard failed!"));
        }
        LifeCycle.State state = this.getState();
        try {
            this.stateHolder.set(LifeCycle.State.STARTING);
            this.lifeCycleListener.beforeStart(this);
            this.doStart();
            this.lifeCycleListener.afterStart(this);
            if (this.stateHolder.compareAndSet(LifeCycle.State.STARTING, LifeCycle.State.STARTED)) {
                LifeCycle.LifeCycleResult lifeCycleResult = LifeCycle.LifeCycleResult.success();
                return lifeCycleResult;
            }
            String message = String.format("move state to STARTED failed while start, which current state: '%s'", new Object[]{this.getState()});
            LifeCycle.LifeCycleResult lifeCycleResult = LifeCycle.LifeCycleResult.failure(new IllegalStateException(message));
            return lifeCycleResult;
        }
        catch (Throwable throwable) {
            this.stateHolder.set(state);
            LifeCycle.LifeCycleResult lifeCycleResult = LifeCycle.LifeCycleResult.failure(throwable);
            return lifeCycleResult;
        }
        finally {
            this.guard.release();
        }
    }

    @Override
    public LifeCycle.LifeCycleSupportResult supportStart() {
        if (this.getState() == LifeCycle.State.INITIALIZED) {
            return LifeCycle.LifeCycleSupportResult.support("component ever initialized, ready to start");
        }
        if (this.getState() == LifeCycle.State.STOPPED) {
            return LifeCycle.LifeCycleSupportResult.support("component ever stoped, ready to start");
        }
        return LifeCycle.LifeCycleSupportResult.unsupport(String.format("only can be started while initialized or stoped, current state: '%s'", new Object[]{this.getState()}));
    }

    @Override
    public boolean isStarted() {
        return this.stateHolder.get() == LifeCycle.State.STARTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LifeCycle.LifeCycleResult stop() {
        if (!this.guard.tryAcquire()) {
            return LifeCycle.LifeCycleResult.failure(new IllegalStateException("acquire lifecycle guard failed!"));
        }
        LifeCycle.State state = this.getState();
        try {
            this.stateHolder.set(LifeCycle.State.STOPPING);
            this.lifeCycleListener.beforeStop(this);
            this.doStop();
            this.lifeCycleListener.afterStop(this);
            if (this.stateHolder.compareAndSet(LifeCycle.State.STOPPING, LifeCycle.State.STOPPED)) {
                LifeCycle.LifeCycleResult lifeCycleResult = LifeCycle.LifeCycleResult.success();
                return lifeCycleResult;
            }
            String message = String.format("move state to STOPPED failed while stop, which current state: '%s'", new Object[]{this.getState()});
            LifeCycle.LifeCycleResult lifeCycleResult = LifeCycle.LifeCycleResult.failure(new IllegalStateException(message));
            return lifeCycleResult;
        }
        catch (Throwable throwable) {
            this.stateHolder.set(state);
            LifeCycle.LifeCycleResult lifeCycleResult = LifeCycle.LifeCycleResult.failure(throwable);
            return lifeCycleResult;
        }
        finally {
            this.guard.release();
        }
    }

    @Override
    public LifeCycle.LifeCycleSupportResult supportStop() {
        if (this.getState() == LifeCycle.State.INITIALIZED) {
            return LifeCycle.LifeCycleSupportResult.support("component ever initialized, can stop directly");
        }
        if (this.getState() == LifeCycle.State.STARTED) {
            return LifeCycle.LifeCycleSupportResult.support("component ever started, ready to stop");
        }
        return LifeCycle.LifeCycleSupportResult.unsupport(String.format("only can be stoped while initialized or started, current state: '%s'", new Object[]{this.getState()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LifeCycle.LifeCycleResult stop(Duration timeout) {
        if (!this.guard.tryAcquire()) {
            return LifeCycle.LifeCycleResult.failure(new IllegalStateException("acquire lifecycle guard failed!"));
        }
        LifeCycle.State state = this.getState();
        try {
            CompletableFuture<LifeCycle.LifeCycleResult> future = CompletableFuture.supplyAsync(() -> this.stop());
            LifeCycle.LifeCycleResult lifeCycleResult = future.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            return lifeCycleResult;
        }
        catch (Throwable throwable) {
            this.stateHolder.set(state);
            LifeCycle.LifeCycleResult lifeCycleResult = LifeCycle.LifeCycleResult.failure(throwable);
            return lifeCycleResult;
        }
        finally {
            this.guard.release();
        }
    }

    @Override
    public boolean isStopped() {
        return this.stateHolder.get() == LifeCycle.State.STOPPED;
    }

    protected abstract void doInitialize();

    protected abstract void doStart();

    protected abstract void doStop();

    private static class DelegatingLifeCycleListener<T extends LifeCycle>
    implements LifeCycleListener<T> {
        private final List<LifeCycleListener> listeners = new CopyOnWriteArrayList<LifeCycleListener>();

        private DelegatingLifeCycleListener() {
        }

        @Override
        public void beforeInitialize(T component) {
            for (LifeCycleListener listener : this.listeners) {
                listener.beforeInitialize(component);
            }
        }

        @Override
        public void afterInitialize(T component) {
            for (LifeCycleListener listener : this.listeners) {
                listener.afterInitialize(component);
            }
        }

        @Override
        public void beforeStart(T component) {
            for (LifeCycleListener listener : this.listeners) {
                listener.beforeStart(component);
            }
        }

        @Override
        public void afterStart(T component) {
            for (LifeCycleListener listener : this.listeners) {
                listener.afterStart(component);
            }
        }

        @Override
        public void beforeStop(T component) {
            for (LifeCycleListener listener : this.listeners) {
                listener.beforeStop(component);
            }
        }

        @Override
        public void afterStop(T component) {
            for (LifeCycleListener listener : this.listeners) {
                listener.afterStop(component);
            }
        }
    }
}

