/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.filter;

import cn.sliew.milky.common.concurrent.CallableWrapper;
import cn.sliew.milky.common.concurrent.RunnableWrapper;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public interface ActionListener<Response> {
    public void onResponse(Response var1);

    public void onFailure(Throwable var1);

    default public CompletableFuture<Response> toFuture() {
        CompletableFuture future = new CompletableFuture();
        future.whenComplete((response, throwable) -> {
            if (throwable != null) {
                this.onFailure((Throwable)throwable);
            } else {
                this.onResponse(response);
            }
        });
        return future;
    }

    default public BiConsumer<Response, Throwable> toBiConsumer() {
        return new BiConsumer<Response, Throwable>(){

            @Override
            public void accept(Response response, Throwable throwable) {
                if (throwable != null) {
                    ActionListener.this.onFailure(throwable);
                } else {
                    ActionListener.this.onResponse(response);
                }
            }
        };
    }

    public static Runnable wrap(final Runnable runnable, final ActionListener listener) {
        return new RunnableWrapper(){

            @Override
            public void doRun() throws Exception {
                runnable.run();
            }

            @Override
            public void onAfter() {
                listener.onResponse(null);
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        };
    }

    public static <T> Callable<T> wrap(final Callable<T> callable, final ActionListener<T> listener) {
        return new CallableWrapper<T>(){

            @Override
            public T doCall() throws Exception {
                return callable.call();
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            @Override
            public void onAfter(T result) throws Exception {
                listener.onResponse(result);
            }
        };
    }
}

