/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.concurrent;

import java.util.concurrent.Callable;

public interface CallableWrapper<T>
extends Callable<T> {
    @Override
    default public T call() throws Exception {
        T result = null;
        try {
            this.onBefore();
            result = this.doCall();
            this.onAfter(result);
        }
        catch (Exception t) {
            this.onFailure(t);
        }
        finally {
            this.onFinal();
        }
        return result;
    }

    public T doCall() throws Exception;

    public void onFailure(Exception var1);

    default public void onBefore() throws Exception {
    }

    default public void onAfter(T result) throws Exception {
    }

    default public void onFinal() {
    }
}

