/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.io;

import cn.sliew.milky.io.BitUtil;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.Flushable;
import java.io.IOException;
import java.io.Serializable;

public interface DataOutputView
extends DataOutput,
Closeable,
Flushable,
Serializable {
    public static final byte ZERO = 0;
    public static final byte ONE = 1;
    public static final byte TWO = 2;

    public void writeBytes(byte[] var1) throws IOException;

    public void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    @Override
    default public void write(byte[] b) throws IOException {
        this.writeBytes(b);
    }

    @Override
    default public void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len);
    }

    @Override
    default public void writeBoolean(boolean v) throws IOException {
        this.writeByte(v ? 1 : 0);
    }

    default public void writeOptionalBoolean(Boolean b) throws IOException {
        if (b == null) {
            this.writeByte(2);
        } else {
            this.writeBoolean(b);
        }
    }

    @Override
    default public void writeShort(int v) throws IOException {
        byte[] buffer = this.getBuffer();
        buffer[0] = (byte)(v >> 8);
        buffer[1] = (byte)v;
        this.writeBytes(buffer, 0, 2);
    }

    @Override
    default public void writeChar(int v) throws IOException {
        byte[] buffer = this.getBuffer();
        buffer[0] = (byte)(v >>> 8);
        buffer[1] = (byte)v;
        this.writeBytes(buffer, 0, 2);
    }

    @Override
    default public void writeInt(int v) throws IOException {
        byte[] buffer = this.getBuffer();
        buffer[0] = (byte)(v >> 24);
        buffer[1] = (byte)(v >> 16);
        buffer[2] = (byte)(v >> 8);
        buffer[3] = (byte)v;
        this.writeBytes(buffer, 0, 4);
    }

    default public void writeVInt(int v) throws IOException {
        if (Integer.numberOfLeadingZeros(v) >= 25) {
            this.writeByte((byte)v);
            return;
        }
        byte[] buffer = this.getBuffer();
        int index = 0;
        do {
            buffer[index++] = (byte)(v & 0x7F | 0x80);
        } while (((v >>>= 7) & 0xFFFFFF80) != 0);
        buffer[index++] = (byte)v;
        this.writeBytes(buffer, 0, index);
    }

    default public void writeZInt(int v) throws IOException {
        this.writeVInt(BitUtil.zigZagEncode(v));
    }

    default public void writeOptionalInt(Integer integer) throws IOException {
        if (integer == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeInt(integer);
        }
    }

    default public void writeOptionalVInt(Integer integer) throws IOException {
        if (integer == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeVInt(integer);
        }
    }

    @Override
    default public void writeLong(long i) throws IOException {
        byte[] buffer = this.getBuffer();
        buffer[0] = (byte)(i >> 56);
        buffer[1] = (byte)(i >> 48);
        buffer[2] = (byte)(i >> 40);
        buffer[3] = (byte)(i >> 32);
        buffer[4] = (byte)(i >> 24);
        buffer[5] = (byte)(i >> 16);
        buffer[6] = (byte)(i >> 8);
        buffer[7] = (byte)i;
        this.writeBytes(buffer, 0, 8);
    }

    default public void writeVLong(long i) throws IOException {
        byte[] buffer = this.getBuffer();
        int index = 0;
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buffer[index++] = (byte)(i & 0x7FL | 0x80L);
            i >>>= 7;
        }
        buffer[index++] = (byte)i;
        this.writeBytes(buffer, 0, index);
    }

    default public void writeZLong(long i) throws IOException {
        byte[] buffer = this.getBuffer();
        int index = 0;
        long value = BitUtil.zigZagEncode(i);
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buffer[index++] = (byte)(value & 0x7FL | 0x80L);
            value >>>= 7;
        }
        buffer[index++] = (byte)(value & 0x7FL);
        this.writeBytes(buffer, 0, index);
    }

    default public void writeOptionalLong(Long l) throws IOException {
        if (l == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeLong(l);
        }
    }

    default public void writeOptionalVLong(Long l) throws IOException {
        if (l == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeVLong(l);
        }
    }

    default public void writeOptionalZLong(Long l) throws IOException {
        if (l == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeZLong(l);
        }
    }

    @Override
    default public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    default public void writeVFloat(float value, float precision) throws IOException {
        this.writeVInt((int)(value * precision));
    }

    default public void writeVDouble(double value, double precision, boolean optimizePositive) throws IOException {
        this.writeVLong((long)(value * precision));
    }

    default public void writeOptionalFloat(Float v) throws IOException {
        if (v == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeFloat(v.floatValue());
        }
    }

    @Override
    default public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    default public void writeOptionalDouble(Double v) throws IOException {
        if (v == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeDouble(v);
        }
    }

    public byte[] getBuffer();

    @Override
    public void flush() throws IOException;

    @Override
    public void close() throws IOException;
}

