/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.io;

import cn.sliew.milky.io.BitUtil;
import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;

public interface DataInputView
extends DataInput,
Closeable,
Serializable {
    public void readBytes(byte[] var1) throws IOException;

    public void readBytes(byte[] var1, int var2, int var3) throws IOException;

    @Override
    default public void readFully(byte[] b) throws IOException {
        this.readBytes(b);
    }

    @Override
    default public void readFully(byte[] b, int off, int len) throws IOException {
        this.readBytes(b, off, len);
    }

    @Override
    default public boolean readBoolean() throws IOException {
        byte value = this.readByte();
        if (value == 0) {
            return false;
        }
        if (value == 1) {
            return true;
        }
        String message = String.format(Locale.ROOT, "unexpected byte [0x%02x]", value);
        throw new IllegalStateException(message);
    }

    default public Boolean readOptionalBoolean() throws IOException {
        byte value = this.readByte();
        if (value == 2) {
            return null;
        }
        if (value == 0) {
            return false;
        }
        if (value == 1) {
            return true;
        }
        String message = String.format(Locale.ROOT, "unexpected byte [0x%02x]", value);
        throw new IllegalStateException(message);
    }

    @Override
    default public short readShort() throws IOException {
        return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    @Override
    default public int readUnsignedShort() throws IOException {
        return (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    @Override
    default public char readChar() throws IOException {
        return (char)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    @Override
    default public int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    default public int readVInt() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        if ((b & 0x80) != 0) {
            throw new IOException("Invalid vInt ((" + Integer.toHexString(b) + " & 0x7f) << 28) | " + Integer.toHexString(i));
        }
        return i | (b & 0x7F) << 28;
    }

    default public int readZInt() throws IOException {
        return BitUtil.zigZagDecode(this.readVInt());
    }

    default public Integer readOptionalInt() throws IOException {
        if (this.readBoolean()) {
            return this.readInt();
        }
        return null;
    }

    default public Integer readOptionalVInt() throws IOException {
        if (this.readBoolean()) {
            return this.readVInt();
        }
        return null;
    }

    default public Integer readOptionalZInt() throws IOException {
        if (this.readBoolean()) {
            return this.readZInt();
        }
        return null;
    }

    @Override
    default public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    default public long readVLong() throws IOException {
        byte b = this.readByte();
        long i = (long)b & 0x7FL;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 28;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 35;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 42;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 49;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 56;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        if (b != 0 && b != 1) {
            throw new IOException("Invalid vlong (" + Integer.toHexString(b) + " << 63) | " + Long.toHexString(i));
        }
        return i |= (long)b << 63;
    }

    default public long readZLong() throws IOException {
        long currentByte;
        long accumulator = 0L;
        int i = 0;
        while (((currentByte = (long)this.readByte()) & 0x80L) != 0L) {
            accumulator |= (currentByte & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw new IOException("variable-length stream is too long");
        }
        return BitUtil.zigZagDecode(accumulator | currentByte << i);
    }

    default public Long readOptionalLong() throws IOException {
        if (this.readBoolean()) {
            return this.readLong();
        }
        return null;
    }

    default public Long readOptionalVLong() throws IOException {
        if (this.readBoolean()) {
            return this.readVLong();
        }
        return null;
    }

    default public Long readOptionalZLong() throws IOException {
        if (this.readBoolean()) {
            return this.readZLong();
        }
        return null;
    }

    @Override
    default public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    default public float readVFloat(float precision, boolean optimizePositive) throws IOException {
        return (float)this.readVInt() / precision;
    }

    default public double readVarDouble(double precision) throws IOException {
        return (double)this.readVLong() / precision;
    }

    default public Float readOptionalFloat() throws IOException {
        if (this.readBoolean()) {
            return Float.valueOf(this.readFloat());
        }
        return null;
    }

    @Override
    default public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    default public Double readOptionalDouble() throws IOException {
        if (this.readBoolean()) {
            return this.readDouble();
        }
        return null;
    }
}

