/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.event.reactor;

import cn.sliew.milky.event.Event;
import cn.sliew.milky.event.EventBus;
import cn.sliew.milky.event.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ReactorEventBus<E extends Event>
implements EventBus {
    private volatile List<EventListener<E>> eventListeners = new LinkedList<EventListener<E>>();

    @Override
    public void fire(Event event) {
        Mono.justOrEmpty((Object)event).subscribeOn(Schedulers.fromExecutor((Executor)this.getExecutor())).subscribe(e -> this.eventListeners.stream().forEach(listener -> listener.execute(e)));
    }

    public void register(EventListener listener) {
        LinkedList<EventListener<EventListener<EventListener>>> listeners = new LinkedList<EventListener<EventListener<EventListener>>>(this.eventListeners);
        listeners.add(listener);
        this.eventListeners = listeners;
    }

    @Override
    public void register(Class<? extends Event> clazz, EventListener listener) {
        this.register(listener);
    }
}

