/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.component;

import cn.sliew.milky.common.constant.AttributeKey;
import cn.sliew.milky.common.constant.Tag;
import cn.sliew.milky.component.Component;
import cn.sliew.milky.component.ComponentRegistry;
import cn.sliew.milky.registry.AbstractRegistry;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractComponentRegistry<E extends Component, C>
extends AbstractRegistry<E, C>
implements ComponentRegistry<E, C> {
    public Optional<E> lookup(String name) {
        return this.entries.find(name);
    }

    public Set<String> lookup(Class componentType) {
        return this.entries.values().stream().filter(component -> component.getClass().equals(componentType)).map(Component::getName).collect(Collectors.toSet());
    }

    @Override
    public Set<String> lookup(Tag tag) {
        return this.entries.values().stream().filter(component -> component.hasTag(tag)).map(Component::getName).collect(Collectors.toSet());
    }

    @Override
    public Set<String> lookup(AttributeKey key) {
        return this.entries.values().stream().filter(component -> component.hasAttr(key)).map(Component::getName).collect(Collectors.toSet());
    }

    @Override
    public boolean exists(String name) {
        return this.entries.exists(name);
    }

    public boolean exists(Component component) {
        return this.exists(component.getName());
    }
}

