/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.watchdog;

import cn.sliew.milky.common.watchdog.ThreadWatchdog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.LongSupplier;

public class DefaultThreadWatchdog
implements ThreadWatchdog {
    private final long interval;
    private final long maxExecutionTime;
    private final LongSupplier relativeTimeSupplier;
    private final BiFunction<Long, Runnable, ScheduledFuture<?>> scheduler;
    private final AtomicInteger registered = new AtomicInteger(0);
    private final AtomicBoolean running = new AtomicBoolean(false);
    final ConcurrentHashMap<Thread, Long> registry = new ConcurrentHashMap();

    DefaultThreadWatchdog(long interval, long maxExecutionTime, LongSupplier relativeTimeSupplier, BiFunction<Long, Runnable, ScheduledFuture<?>> scheduler) {
        this.interval = interval;
        this.maxExecutionTime = maxExecutionTime;
        this.relativeTimeSupplier = relativeTimeSupplier;
        this.scheduler = scheduler;
    }

    @Override
    public void register() {
        this.registered.getAndIncrement();
        Long previousValue = this.registry.put(Thread.currentThread(), this.relativeTimeSupplier.getAsLong());
        if (previousValue != null) {
            throw new NullPointerException();
        }
        if (this.running.compareAndSet(false, true)) {
            this.scheduler.apply(this.interval, this::interruptLongRunningExecutions);
        }
    }

    @Override
    public long maxExecutionTimeInMillis() {
        return this.maxExecutionTime;
    }

    @Override
    public void unregister() {
        Long previousValue = this.registry.remove(Thread.currentThread());
        if (previousValue == null) {
            throw new NullPointerException();
        }
        this.registered.decrementAndGet();
    }

    private void interruptLongRunningExecutions() {
        long currentRelativeTime = this.relativeTimeSupplier.getAsLong();
        for (Map.Entry<Thread, Long> entry : this.registry.entrySet()) {
            if (currentRelativeTime - entry.getValue() <= this.maxExecutionTime) continue;
            entry.getKey().interrupt();
        }
        if (this.registered.get() > 0) {
            this.scheduler.apply(this.interval, this::interruptLongRunningExecutions);
        } else {
            this.running.set(false);
        }
    }
}

