/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.settings;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;

final class FilteredMap
extends AbstractMap<String, Object> {
    private final Map<String, Object> delegate;
    private final Predicate<String> filter;
    private final String prefix;
    private int size = -1;

    FilteredMap(Map<String, Object> delegate, Predicate<String> filter, String prefix) {
        this.delegate = delegate;
        this.filter = filter;
        this.prefix = prefix;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        final Set<Map.Entry<String, Object>> delegateSet = this.delegate.entrySet();
        return new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                final Iterator iter = delegateSet.iterator();
                return new Iterator<Map.Entry<String, Object>>(){
                    private int numIterated;
                    private Map.Entry<String, Object> currentElement;

                    @Override
                    public boolean hasNext() {
                        if (this.currentElement != null) {
                            return true;
                        }
                        if (this.numIterated == FilteredMap.this.size) {
                            assert (FilteredMap.this.size != -1) : "size was never set: " + this.numIterated + " vs. " + FilteredMap.access$000(FilteredMap.this);
                            return false;
                        }
                        while (iter.hasNext()) {
                            this.currentElement = (Map.Entry)iter.next();
                            if (!FilteredMap.this.filter.test(this.currentElement.getKey())) continue;
                            ++this.numIterated;
                            return true;
                        }
                        this.currentElement = null;
                        return false;
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        if (this.currentElement == null && !this.hasNext()) {
                            throw new NoSuchElementException("make sure to call hasNext first");
                        }
                        final Map.Entry<String, Object> current = this.currentElement;
                        this.currentElement = null;
                        if (FilteredMap.this.prefix == null) {
                            return current;
                        }
                        return new Map.Entry<String, Object>(){

                            @Override
                            public String getKey() {
                                return ((String)current.getKey()).substring(FilteredMap.this.prefix.length());
                            }

                            @Override
                            public Object getValue() {
                                return current.getValue();
                            }

                            @Override
                            public Object setValue(Object value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return FilteredMap.this.size();
            }
        };
    }

    @Override
    public Object get(Object key) {
        if (key instanceof String) {
            String theKey;
            String string = theKey = this.prefix == null ? (String)key : this.prefix + key;
            if (this.filter.test(theKey)) {
                return this.delegate.get(theKey);
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            String theKey;
            String string = theKey = this.prefix == null ? (String)key : this.prefix + key;
            if (this.filter.test(theKey)) {
                return this.delegate.containsKey(theKey);
            }
        }
        return false;
    }

    @Override
    public int size() {
        if (this.size == -1) {
            this.size = Math.toIntExact(this.delegate.keySet().stream().filter(this.filter).count());
        }
        return this.size;
    }
}

