/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.context;

import cn.sliew.milky.common.explain.Explanation;
import java.util.HashMap;
import java.util.Map;

public class ExecuteContext {
    private static final ThreadLocal<ExecuteContext> LOCAL = ThreadLocal.withInitial(() -> new ExecuteContext());
    private final Map<String, String> attachments = new HashMap<String, String>();
    private boolean profile = false;
    private boolean explain = false;
    private Explanation explanation = new Explanation();

    protected ExecuteContext() {
    }

    public static ExecuteContext getContext() {
        return LOCAL.get();
    }

    public static void removeContext() {
        LOCAL.remove();
    }

    public String getAttachment(String key) {
        return this.attachments.get(key);
    }

    public ExecuteContext setAttachment(String key, String value) {
        if (value == null) {
            this.attachments.remove(key);
        } else {
            this.attachments.put(key, value);
        }
        return this;
    }

    public ExecuteContext removeAttachment(String key) {
        this.attachments.remove(key);
        return this;
    }

    public Map<String, String> getAttachments() {
        return this.attachments;
    }

    public ExecuteContext setAttachments(Map<String, String> attachment) {
        this.attachments.clear();
        if (attachment != null && attachment.size() > 0) {
            this.attachments.putAll(attachment);
        }
        return this;
    }

    public void clearAttachments() {
        this.attachments.clear();
    }

    public boolean profile() {
        return this.profile;
    }

    public void openProfile() {
        this.profile = true;
    }

    public boolean explain() {
        return this.explain;
    }

    public void openExplain() {
        this.explain = true;
    }
}

