/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.rest.http.util;

import cn.sliew.milky.common.exception.Rethrower;
import cn.sliew.milky.common.util.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.type.CollectionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum FlinkShadedJacksonUtil {

    private static final Logger log = LoggerFactory.getLogger(FlinkShadedJacksonUtil.class);
    public static final ObjectMapper OBJECT_MAPPER = RestMapperUtils.getStrictObjectMapper();

    public static String toJsonString(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException var2) {
            log.error("json \u5e8f\u5217\u5316\u5931\u8d25 object: {}", object, (Object)var2);
            Rethrower.throwAs(var2);
            return null;
        }
    }

    public static <T> T parseJsonString(String json, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (JsonProcessingException var3) {
            log.error("json \u53cd\u5e8f\u5217\u5316\u5931\u8d25 clazz: {}, json: {}", new Object[]{clazz.getName(), json, var3});
            Rethrower.throwAs(var3);
            return null;
        }
    }

    public static <T> T parseJsonString(String json, Class<T> outerType, Class parameterClasses) {
        try {
            JavaType type = OBJECT_MAPPER.getTypeFactory().constructParametricType(outerType, new Class[]{parameterClasses});
            return (T)OBJECT_MAPPER.readValue(json, type);
        }
        catch (JsonProcessingException e) {
            log.error("json \u53cd\u5e8f\u5217\u5316\u5931\u8d25 clazz: {}, json: {}", new Object[]{outerType.getTypeName(), json, e});
            Rethrower.throwAs(e);
            return null;
        }
    }

    public static <T> List<T> parseJsonArray(String json, Class<T> clazz) {
        if (StringUtils.isBlank(json)) {
            return Collections.emptyList();
        }
        try {
            CollectionType listType = OBJECT_MAPPER.getTypeFactory().constructCollectionType(ArrayList.class, clazz);
            return (List)OBJECT_MAPPER.readValue(json, (JavaType)listType);
        }
        catch (Exception var3) {
            log.error("json \u53cd\u5e8f\u5217\u5316\u4e3a list \u5931\u8d25 clazz: {}, json: {}", new Object[]{clazz.getName(), json, var3});
            return Collections.emptyList();
        }
    }

    static {
        OBJECT_MAPPER.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        OBJECT_MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    }
}

