/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.rest.http;

import cn.sliew.milky.common.exception.Rethrower;
import java.io.EOFException;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.stream.Collectors;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(LogInterceptor.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Request request = chain.request();
        this.logRequest(chain.request());
        try {
            Response response = chain.proceed(request);
            this.logResponse(response);
            return response;
        }
        catch (Exception e) {
            log.error("OkHttpClient \u5904\u7406\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            Rethrower.throwAs(e);
            return null;
        }
    }

    private void logRequest(Request request) {
        String method = request.method();
        String url = request.url().toString();
        String requestBody = this.getRequestBody(request.body());
        String headers = request.headers().toMultimap().entrySet().stream().map(entry -> "            " + (String)entry.getKey() + ": " + String.join((CharSequence)";", (Iterable)entry.getValue())).collect(Collectors.joining("\n"));
        if (log.isInfoEnabled()) {
            log.info("{} {} requestBody: {}, headers: \n{}", new Object[]{method, url, requestBody, headers});
        }
    }

    private void logResponse(Response response) throws IOException {
        int code = response.code();
        String message = response.message();
        String responseBody = "";
        if (response.body() != null) {
            responseBody = this.getResponseBody(response.body());
        }
        String headers = response.headers().toMultimap().entrySet().stream().map(entry -> "            " + (String)entry.getKey() + ": " + String.join((CharSequence)";", (Iterable)entry.getValue())).collect(Collectors.joining("\n"));
        long duration = response.receivedResponseAtMillis() - response.sentRequestAtMillis();
        if (log.isInfoEnabled()) {
            log.info("\u8bf7\u6c42\u8017\u65f6: {}ms, code: {}, message: {}, responseBody: {}, headers: \n{}", new Object[]{duration, code, message, responseBody, headers});
        }
    }

    private String getRequestBody(RequestBody requestBody) {
        if (requestBody == null) {
            return "";
        }
        if (requestBody instanceof MultipartBody) {
            return "";
        }
        Buffer buffer = new Buffer();
        try {
            requestBody.writeTo((BufferedSink)buffer);
            return URLDecoder.decode(buffer.readUtf8(), "utf-8");
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6 OKHttpClient \u8bf7\u6c42\u4f53\u5f02\u5e38!", (Throwable)e);
            return "";
        }
    }

    private String getResponseBody(ResponseBody responseBody) throws IOException {
        BufferedSource source = responseBody.source();
        source.request(Long.MAX_VALUE);
        Buffer buffer = source.buffer();
        Charset charset = UTF8;
        MediaType contentType = responseBody.contentType();
        if (contentType != null) {
            try {
                charset = contentType.charset(UTF8);
            }
            catch (UnsupportedCharsetException e) {
                log.error("\u83b7\u53d6 OKHttpClient \u54cd\u5e94\u7f16\u7801\u5f02\u5e38!", (Throwable)e);
            }
        }
        if (!this.isPlaintext(buffer)) {
            return null;
        }
        if (responseBody.contentLength() != 0L) {
            String result = buffer.clone().readString(charset);
            return result;
        }
        return null;
    }

    private boolean isPlaintext(Buffer buffer) {
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                int codePoint = prefix.readUtf8CodePoint();
                if (!Character.isISOControl(codePoint) || Character.isWhitespace(codePoint)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }
}

