/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.rest.http;

import cn.sliew.flinkful.rest.base.JarClient;
import cn.sliew.flinkful.rest.http.AsyncClient;
import cn.sliew.flinkful.rest.http.FlinkHttpClient;
import cn.sliew.flinkful.rest.http.util.FlinkShadedJacksonUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.apache.flink.runtime.rest.messages.EmptyResponseBody;
import org.apache.flink.runtime.rest.messages.JobPlanInfo;
import org.apache.flink.runtime.webmonitor.handlers.JarListInfo;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanRequestBody;
import org.apache.flink.runtime.webmonitor.handlers.JarRunRequestBody;
import org.apache.flink.runtime.webmonitor.handlers.JarRunResponseBody;
import org.apache.flink.runtime.webmonitor.handlers.JarUploadResponseBody;

public class JarHttpClient
extends AsyncClient
implements JarClient {
    private final String webInterfaceURL;

    public JarHttpClient(OkHttpClient client, String webInterfaceURL) {
        super(client);
        this.webInterfaceURL = webInterfaceURL;
    }

    @Override
    public CompletableFuture<JarListInfo> jars() throws IOException {
        String url = this.webInterfaceURL + "/jars";
        Request request = new Request.Builder().get().url(url).build();
        return this.remoteCall(request, JarListInfo.class);
    }

    @Override
    public CompletableFuture<JarUploadResponseBody> uploadJar(String filePath) throws IOException {
        String url = this.webInterfaceURL + "/jars/upload";
        File jarFile = new File(filePath);
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("jarfile", jarFile.getName(), RequestBody.create((File)jarFile, (MediaType)MediaType.get((String)"application/java-archive"))).build();
        Request request = new Request.Builder().post((RequestBody)body).url(url).build();
        return this.remoteCall(request, JarUploadResponseBody.class);
    }

    @Override
    public CompletableFuture<EmptyResponseBody> deleteJar(String jarId) throws IOException {
        String url = this.webInterfaceURL + "/jars/" + jarId;
        Request request = new Request.Builder().delete().url(url).build();
        return this.remoteCall(request);
    }

    @Override
    public CompletableFuture<JobPlanInfo> jarPlan(String jarId, JarPlanRequestBody requestBody) throws IOException {
        String url = this.webInterfaceURL + "/jars/" + jarId + "/plan";
        RequestBody body = RequestBody.create((String)FlinkShadedJacksonUtil.toJsonString(requestBody), (MediaType)FlinkHttpClient.APPLICATION_JSON);
        Request request = new Request.Builder().post(body).url(url).build();
        return this.remoteCall(request, JobPlanInfo.class);
    }

    @Override
    public CompletableFuture<JarRunResponseBody> jarRun(String jarId, JarRunRequestBody requestBody) throws IOException {
        String url = this.webInterfaceURL + "/jars/" + jarId + "/run";
        RequestBody body = RequestBody.create((String)FlinkShadedJacksonUtil.toJsonString(requestBody), (MediaType)FlinkHttpClient.APPLICATION_JSON);
        Request request = new Request.Builder().post(body).url(url).build();
        return this.remoteCall(request, JarRunResponseBody.class);
    }
}

