/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.rest.http;

import cn.sliew.flinkful.rest.base.ClusterClient;
import cn.sliew.flinkful.rest.base.DashboardClient;
import cn.sliew.flinkful.rest.base.DataSetClient;
import cn.sliew.flinkful.rest.base.JarClient;
import cn.sliew.flinkful.rest.base.JobClient;
import cn.sliew.flinkful.rest.base.JobManagerClient;
import cn.sliew.flinkful.rest.base.RestClient;
import cn.sliew.flinkful.rest.base.SavepointClient;
import cn.sliew.flinkful.rest.base.TaskManagerClient;
import cn.sliew.flinkful.rest.http.ClusterHttpClient;
import cn.sliew.flinkful.rest.http.DashboardHttpClient;
import cn.sliew.flinkful.rest.http.DataSetHttpClient;
import cn.sliew.flinkful.rest.http.JarHttpClient;
import cn.sliew.flinkful.rest.http.JobHttpClient;
import cn.sliew.flinkful.rest.http.JobManagerHttpClient;
import cn.sliew.flinkful.rest.http.LogInterceptor;
import cn.sliew.flinkful.rest.http.SavepointHttpClient;
import cn.sliew.flinkful.rest.http.TaskManagerHttpClient;
import java.time.Duration;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import org.apache.flink.runtime.rest.util.RestConstants;
import org.apache.flink.runtime.rest.versioning.RestAPIVersion;

public class FlinkHttpClient
implements RestClient {
    public static final MediaType APPLICATION_JSON = MediaType.get((String)RestConstants.REST_CONTENT_TYPE);
    private final String webInterfaceURL;
    private final OkHttpClient client;

    public FlinkHttpClient(String webInterfaceURL) {
        this.webInterfaceURL = webInterfaceURL + "/" + RestAPIVersion.V1.getURLVersionPrefix();
        this.client = new OkHttpClient.Builder().connectTimeout(Duration.ofSeconds(3L)).readTimeout(Duration.ofSeconds(3L)).writeTimeout(Duration.ofSeconds(3L)).callTimeout(Duration.ofSeconds(3L)).addInterceptor((Interceptor)new LogInterceptor()).build();
    }

    @Override
    public ClusterClient cluster() {
        return new ClusterHttpClient(this.client, this.webInterfaceURL);
    }

    @Override
    public DataSetClient dataSet() {
        return new DataSetHttpClient(this.client, this.webInterfaceURL);
    }

    @Override
    public JarClient jar() {
        return new JarHttpClient(this.client, this.webInterfaceURL);
    }

    @Override
    public JobClient job() {
        return new JobHttpClient(this.client, this.webInterfaceURL);
    }

    @Override
    public JobManagerClient jobManager() {
        return new JobManagerHttpClient(this.client, this.webInterfaceURL);
    }

    @Override
    public TaskManagerClient taskManager() {
        return new TaskManagerHttpClient(this.client, this.webInterfaceURL);
    }

    @Override
    public SavepointClient savepoint() {
        return new SavepointHttpClient(this.client, this.webInterfaceURL);
    }

    @Override
    public DashboardClient dashboard() {
        return new DashboardHttpClient(this.client, this.webInterfaceURL);
    }
}

